/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model.exons;

import java.util.List;
import org.rhwlab.gene.model.Annotation;

/**
 *
 * @author gevirl
 */
public class ExonID {
    public Annotation geneAnnot;
    public int start;
    public int end;
    public String id;
    
    public static void nameExons(List<ExonID> exons){
        int prevEnd = -1;
        String name = null;
        
        int e = 0;
        char suffix = 'a';
        int regions = 0;
        ExonID prevData = null;
        for (ExonID exon : exons){
            if (exon.start == prevEnd + 1){
                ++regions;
            } else {
                if (prevData != null && prevData.id.endsWith("a")){
                    prevData.id = prevData.id.replaceAll("a","");
                }
                ++e;
                regions = 0;
            }
            name = String.format("E%03d%c", e , suffix+regions);
            exon.id = name;
            prevEnd = exon.end;
            prevData = exon;
        }
        if (prevData.id.endsWith("a")){
            prevData.id = prevData.id.replaceAll("a","");
        }
    }
}
