/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model.exons;

/**
 *
 * @author gevirl
 */
public class ExonData {
    public ExonData(String[] tokens){
        this.exonName = tokens[0];
        this.wbgene = tokens[1];
        this.geneName = tokens[2];
        this.chrom = tokens[3];
        this.start = Integer.valueOf(tokens[4]);
        this.end = Integer.valueOf(tokens[5]);
        this.len = Integer.valueOf(tokens[6]);
        this.data = new double[tokens.length-7];
        for (int i=0 ; i< this.data.length ; ++i){
            data[i] = Double.valueOf(tokens[i+7]);
        }
    }
    public String[] asTokens(){
        String[] ret = new String[data.length+7];
        ret[0] = this.exonName;
        ret[1] = this.wbgene;
        ret[2] = this.geneName;
        ret[3] = this.chrom;
        ret[4] = Integer.toString(this.start);
        ret[5] = Integer.toString(this.end);
        ret[6] = Integer.toString(this.len);
        for (int i=0 ; i<data.length ; ++i){
            ret[i+7] = String.format("%.3f",data[i]);
        }
        
        return ret;
    }
    public String wbgene;
//    public String locus;
//    public String seqname;
    public String geneName;
    public String chrom;
    public int start;
    public int end;
    public int len;
    public double[] data;
    public String exonName;
}
