/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model;

import java.util.Comparator;

/**
 *
 * @author gevirl
 */
public class AnnotationBoundary implements Boundary,Comparable {
    int loc;
    
    AnnotationBoundary(int loc){
        this.loc = loc;
    }
    @Override
    public int getLocation() {
        return this.loc;
    }    

    @Override
    public int compareTo(Object o) {
        AnnotationBoundary other = (AnnotationBoundary)o;
        int ret = Integer.compare(this.loc, other.loc);
        if (ret == 0){
            if (this instanceof AnnotationStart){
                if (o instanceof AnnotationEnd){
                    ret = -1;
                } else {
                    ret = 0;
                }
            } else {
                if (o instanceof AnnotationEnd){
                    ret = 0;
                } else {
                    ret = 1;
                }
            }
        }
        return ret;
    }
    static public Comparator getComparator(){
        Comparator ret = new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                AnnotationBoundary b1 = (AnnotationBoundary)o1;
                AnnotationBoundary b2 = (AnnotationBoundary)o2;
                int ret = Integer.compare(b1.loc, b2.loc);
                if (ret == 0){
                    if (b1 instanceof AnnotationStart){
                        if (b2 instanceof AnnotationEnd){
                            ret = -1;
                        } else {
                            ret = 0;
                        }
                    } else {
                        if (b2 instanceof AnnotationEnd){
                            ret = 0;
                        } else {
                            ret = 1;
                        }
                    }
                }
                return ret;                
            }
        };
        return ret;
    }
}
