/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
abstract public class Annotation implements Comparable {
    public Annotation() {
        
    }

    public Annotation(String[] tokens){
        int iuasdfiuhsf=0;
        this.chromo = tokens[0];
        if (remapChromo){
            String chr = chromoRenameMap.get(tokens[0]);
            if (chr != null){
                this.chromo = chr;
            }
        }
        source = tokens[1];
        this.type = tokens[2];
        this.start = Integer.valueOf(tokens[3]);
        this.end = Integer.valueOf(tokens[4]);
        this.strand = tokens[6];
        this.phase = tokens[7]; 
        String[] attrs = tokens[8].split(";");
        for (String attr : attrs){

            String[] attrTokens;
            if (attr.contains("=")){
                attrTokens = attr.trim().split("=");    
            } else if (attr.contains(" ")){
                attrTokens = attr.trim().split(" ");
            } else {
                attrTokens = new String[2];
                attrTokens[0] = "Name";
                attrTokens[1] = attr;
            }

            attrTokens[1] = attrTokens[1].replaceAll("\"", "");   // remove any quotes from the attribute value

            if (!attrTokens[1].contains(",")){
                attributes.put(attrTokens[0],attrTokens[1]);
            }else {
                ArrayList<String> values = new ArrayList<>();
                for (String value : attrTokens[1].split(",")){
                    values.add(value);
                }
                attributes.put(attrTokens[0],values);
            }                
        }             
    }

    public boolean hasAttributeValue(String attrValue){
        String[] tokens = attrValue.split("=");
        Object val = this.getAttributeValue(tokens[0]);
        if (val == null){
            return false;
        }
        if (val instanceof List){
            for (Object obj : (List)val){
                String s = (String)obj;
                if (s.equals(tokens[1])){
                    return true;
                }
            }
            return false;
        }
        String s = (String)val;
        if (s.equals(tokens[1])){
            return true;
        }
        return false;
    }
    public Object getAttributeValue(String attr) {
        return attributes.get(attr);
    }
    public void addAttribute(String key,String attr){
        this.attributes.put(key, attr);
    }

    public void addAttribute(String key,List<String> attr){
        this.attributes.put(key, attr);
    }    
    @Override
    public int compareTo(Object o) {
        return comparer.compare(this, o);
    }   

    public String getChromosome(){
        return this.chromo;
    }
    public String getType(){
        return this.type;
    }     
    public int getLength(){
        return end-start+1;
    }
    public String getStrand(){
        return this.strand;
    }
    public void setGene(String gene){
        this.gene_id=gene;
    }
    public String getPhase(){
        return this.phase;
    }
    public void setTranscript(Object tr){
        this.transcript_id=tr;
    }
    abstract public void print(PrintStream stream);
    
    // print as GTF entry
    public void printAsGTF(PrintStream stream){
        stream.printf("%s\t%s\t%s\t%d\t%d\t.\t%s\t%s\tgene_id \"%s\"", chromo,source,type,start,end,strand,phase,gene_id);
        if (transcript_id != null){
            stream.printf(" ; transcript_id \"%s\"", transcript_id);
        }
        for (String key : attributes.keySet()){
            stream.printf(" ; %s \"%s\"", key,attributes.get(key));
        }
        stream.println();
    }
    public String getGeneID(){
        return gene_id;
    }
    public int getStart(){
        return this.start;
    }
    public int getEnd(){
        return this.end;
    }
    public String getSource(){
        return this.source;
    }

    public boolean overlaps(Annotation other){
        if (this.end < other.start){
            return false;
        }
        if (this.start > other.end){
            return false;
        }
        return true;
    }


    public void setChromo(String s){
        this.chromo = s;
    }
    public void setSource(String s){
        this.source = s;
    }
    public void setType(String s){
        this.type = s;
    }
    public void setPhase(String s){
        this.phase = s;
    }
    public void setStart(int i){
        this.start = i;
    }
    public void setEnd(int i){
        this.end = i;
    }
    public void setStrand(String s){
        this.strand = s;
    }
    public boolean contains(String chr,int pos){
        if (!chr.equals(chromo)){
            return false;
        }
        if (start <= pos && pos <= end){
            return true;
        }
        return false;
    }
    public String getGeneName(){
        if (this.type.equals("gene")){
            Object locus = this.getAttributeValue("locus");
            if (locus != null){
                return (String)locus;
            } else {
                Object seqName = this.getAttributeValue("sequence_name");
                return (String)seqName;
            }
        }
        return null;
    }
    public void setID(String id){
        this.id = id;
    }
    public String getTranscript(){
        return (String)this.getAttributeValue("transcript_id");
    }
    public int distanceFromStart(int pos){
        if (strand.equals("+")){
            return pos - this.start;
        } else {
            return this.end -pos;
        }
    }
    public int distanceFromEnd(int pos){
        if (strand.equals("+")){
            return pos - this.end;
        } else {
            return this.start -pos;
        }
    }    
    String id;
    String gene_id;
    Object transcript_id;
    String chromo;
    String source;
    String type;
    String phase;
    int start;
    int end;
    String strand;
    HashMap<String,Object> attributes=new HashMap<>();
    
    static AnnotationComparator comparer = new AnnotationComparator();
    public static TreeMap<String,String> chromoRenameMap;
    {   chromoRenameMap = new TreeMap<>();
        chromoRenameMap.put("I","chrI");
        chromoRenameMap.put("II","chrII");
        chromoRenameMap.put("III","chrIII");
        chromoRenameMap.put("IV","chrIV");
        chromoRenameMap.put("V","chrV");
        chromoRenameMap.put("X","chrX");
        chromoRenameMap.put("MtDNA","chrM");     
    }
    public static boolean remapChromo = true;
   
}