/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.formats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class GFF3 {
    public GFF3(){
        
    }
    public GFF3(String file)throws Exception {
        this.setFile(file);
        init();
    }
    public void init() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(gff3));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            String[] atts = tokens[8].split(";");
            Entry entry = new Entry();
            if (tokens[0].contains("CHROMOSOME")){
                entry.chromosome = tokens[0].substring(tokens[0].indexOf("_")+1);
            } else {
                entry.chromosome = tokens[0];
            }
            entry.source = tokens[1];
            entry.type = tokens[2];
            entry.start = Integer.valueOf(tokens[3]);
            entry.end = Integer.valueOf(tokens[4]);
            entry.strand = tokens[6];
            for (String att : atts){
                String[] values = att.split("=");
                entry.attributes.put(values[0], values[1]);
            }
            entry.key = entry.attributes.get("Name");
            if (entry.key == null){
                entry.key = entry.attributes.get("ID").split(":")[1];
            }
            entryMap.put(entry.key, entry);
            if (entry.strand.equals("+")){
                addToMap(plusStartMap,entry.start,entry);
                addToMap(plusEndMap,entry.end,entry);
            } else if(entry.strand.equals("-")){
                addToMap(minusStartMap,entry.start,entry);
                addToMap(minusEndMap,entry.end,entry);
            } else {
                System.out.printf("Error: unknown strand in GFF3 for %s\n",entry.key);
            }
            line = reader.readLine();
        }
        reader.close();
    }
    public void setFile(Object obj){
        if (obj instanceof File){
            gff3 = (File)obj;
        }else if (obj instanceof String){
            gff3 = new File((String)obj);
        }
    }
    public Entry getEntry(String id){
        return entryMap.get(id);
    }
    public Set<String> getIDs(){
        return entryMap.keySet();
    }
    private void addToMap(HashMap<String,TreeMap<Integer,Entry>> map,Integer loc,Entry entry){
        TreeMap<Integer,Entry> chromoMap = map.get(entry.chromosome);
        if (chromoMap == null){
            chromoMap = new TreeMap<>();
            map.put(entry.chromosome, chromoMap);
        }
        chromoMap.put(loc,entry);
    }
  
    // find the gene next lower on chromosome than the given location
    public String lowerPlus(String chr,int loc){
        TreeMap<Integer,Entry> ends = plusEndMap.get(chr);
        Integer lower = ends.lowerKey(loc);
        if (lower == null) return null;
        
        return ends.get(lower).key;
    }
    
    // find the gene next upper on chromosome than the given location
    public String upperPlus(String chr,int loc){
        TreeMap<Integer,Entry> starts = plusStartMap.get(chr);
        Integer upper = starts.higherKey(loc);
        if (upper == null) return null;
        
        return starts.get(upper).key;
    }    
    // find the gene next lower on chromosome than the given location
    public String lowerMinus(String chr,int loc){
        TreeMap<Integer,Entry> ends = minusEndMap.get(chr);
        if (ends == null){
            return null;
        }
        Integer lower = ends.lowerKey(loc);
        if (lower == null) return null;
        
        return ends.get(lower).key;
    }
    
    // find the gene next upper on chromosome than the given location
    public String upperMinus(String chr,int loc){
        TreeMap<Integer,Entry> starts = minusStartMap.get(chr);
        if (starts == null){
            return null;
        }        
        Integer upper = starts.higherKey(loc);
        if (upper == null) return null;
        
        return starts.get(upper).key;
    } 
    // build an index of  entries using an attribute as the key
    public HashMap<String,Entry> buildAtributeIndex(String attr){
        HashMap<String,Entry> ret = new HashMap<>();
        for (Entry entry : entryMap.values()){
            String attrValue = entry.attributes.get(attr);
            if (attrValue != null){
                ret.put(attrValue, entry);
            }
        }
        return ret;
    }
    
    File gff3;
    HashMap<String,Entry> entryMap = new HashMap<>();  // Entry indexed by key
    HashMap<String,TreeMap<Integer,Entry>> plusStartMap = new HashMap<>();  // entry on plus strand indexed by chromosome and start
    HashMap<String,TreeMap<Integer,Entry>> plusEndMap = new HashMap<>();// entry on plus strand indexed by chromosome and end
    HashMap<String,TreeMap<Integer,Entry>> minusStartMap = new HashMap<>();  // entry on minus strand indexed by chromosome and start
    HashMap<String,TreeMap<Integer,Entry>> minusEndMap = new HashMap<>();// entry on minus strand indexed by chromosome and end 
    
    public class Entry{
        public String chromosome;
        public String source;
        public String type;
        public int start;
        public int end;
        public String strand;
        public HashMap<String,String> attributes = new HashMap<>();
        public String key;
    }
    
    static public void main(String[] args) throws Exception {
        GFF3 geneGFF = new GFF3("/net/waterston/vol9/References/WS245/WormBaseGene.gff3");
        GFF3 gff = new GFF3("/net/waterston/vol9/References/WS245/wormbase.gff3");
        int n=0;
        for (String id : geneGFF.getIDs()){
            Entry entry = geneGFF.getEntry(id);
            String type = entry.attributes.get("biotype");
            if (type.equals("protein_coding")){
                ++n;
            }
            int oaifsiof=0;
        }
        
        TreeSet<String> wbGenes = new TreeSet<>();
        BufferedReader reader = new BufferedReader(new FileReader("/net/waterston/vol9/References/WS245/SteepTranscriptSet"));
        PrintStream stream = new PrintStream("/net/waterston/vol9/References/WS245/SteepWBGeneSet");
        String line = reader.readLine();
        while (line != null){
            Entry e = gff.getEntry(line);
            String parent = e.attributes.get("Parent");
            String wbGene = parent.split(":")[1];
            wbGenes.add(wbGene);
            line = reader.readLine();
        }
        for (String wbGene : wbGenes){
            stream.println(wbGene);
        }
        int ashfhsd=0;
    }
    
}
