/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import java.awt.image.BufferedImage;
import java.awt.*;
import java.awt.geom.*;
import java.util.HashMap;
import org.rhwlab.expression.*;

/**
 *
 * @author Luke
 */
// produce a buffered image of the expression time series
// use a specified onset
public class TimeSeriesImage {
    public BufferedImage getImage(){
        image = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, dim.width, dim.height);
        Color cur = g2.getColor();
        g2.setColor(Color.BLACK);
        dx = (float)dim.width/(float)timeSeries.size();

        if (yScale != null){
            dy = (float)dim.height/yScale.getDelta();
            yMin = yScale.getMin();
        } else {
            dy = (float)dim.height/(float)(timeSeries.getRange());
            yMin = timeSeries.getMin();
        }
        
        // draw each time point
        String label = timeSeries.getLabel(0);
        for (int i=0 ; i<timeSeries.size(); ++i){
            float x = i*dx;
            float y = dim.height - (timeSeries.get(i)-yMin)*dy;
            float radius = (float)3.0;
            Ellipse2D e = new Ellipse2D.Float(x,y,radius,radius); 
            g2.draw(e);
          
            // draw a vertical line where each cell division occurs
            String cLabel = timeSeries.getLabel(i);
            if (cLabel.compareTo(label)!=0){
                g2.draw(new Line2D.Float(x,0,x,dim.height));
                if (labelCells) {
                    // label the vertical line if not the last cell
                    if (!timeSeries.getLastLabel().equals(cLabel))
                        g2.drawString(cLabel, x, 15);
                }
                label = cLabel;
            }           
        }
        
        // vertical axis labels
        int maxExp;
        int minExp;
        if (yScale == null){
            maxExp = timeSeries.getMax();
            minExp = timeSeries.getMin();
        } else {
            maxExp = (int)yScale.getMax();
            minExp = (int)yScale.getMin();
        }
        int incr = (maxExp-minExp)/nZones;
        for (int i=0 ; i<nZones ; ++i){
            float y = dim.height - (timeSeries.get(i)-timeSeries.getMin())*dy;
            String yVal = Integer.toString(minExp + incr*i);
            g2.drawString(yVal, 0,dim.height*(1-(float)i/(float)nZones));
        }
        
        // draw the x - axis
        float y0 = dim.height +(yMin)*dy;
        Line2D line = new Line2D.Float(0.0f,y0, (float)timeSeries.size()*dx,y0);
        g2.draw(line);

        // add the annotations
        for (Object annotation : annotations.values()){
            if (annotation instanceof ExpressionOnset){
                annotateWithOnset((ExpressionOnset)annotation);
            } else if (annotation instanceof ExpressionWindow ){
                annotateWithWindow((ExpressionWindow)annotation);
            }
        }
        g2.setColor(cur);         
        return image;
    }
    private void annotateWithWindow(ExpressionWindow wind){
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.RED);
        Point2D.Float[] corners = wind.getCorners();
        
        int onset = wind.getStart();
        int end = wind.getEnd();
        float base = wind.getBase();
        float mean = wind.getMean();
        int n = timeSeries.size();
        
        float baseY = dim.height - (base-yMin)*dy;
        float topY = dim.height - (base+corners[1].y-yMin)*dy;
 //       g2.draw(new Line2D.Float(0,baseY,onset*dx,baseY));  // horizontal line
        g2.draw(new Line2D.Float(corners[1].x*dx,topY,corners[2].x*dx,topY));  // horizontal line
//        g2.draw(new Line2D.Float(end*dx,baseY,n*dx,baseY));  // horizontal line
        
        g2.draw(new Line2D.Float(onset*dx,baseY,corners[1].x*dx,topY));  // vertical line
        g2.draw(new Line2D.Float(end*dx,baseY,corners[2].x*dx,topY));  // vertical line
        
    }
    private  void annotateWithOnset(ExpressionOnset on){
        Graphics2D g2 = image.createGraphics();
        // draw a vertical onset line
        g2.setColor(Color.RED);        
        if (on != null){
            int onset = on.getOnset();
            // draw a vertical onset line
            g2.draw(new Line2D.Float(onset*dx,0,onset*dx,dim.height));  // vertical line
            if (onsetLabels) {
                g2.drawString(on.getLabel(),dim.width/5,dim.height/2);
            }
            float base = (float)on.getBase();
            float slope = (float)on.getSlope();
            float yy2 = dim.height - (base-yMin)*dy;
            g2.draw(new Line2D.Float(0,yy2,onset*dx,yy2));  // horizontal
            int n = timeSeries.size()-onset;

            float y2 = dim.height-(float)(base-yMin+slope*n)*dy;
            g2.draw(new Line2D.Float(onset*dx,yy2,(timeSeries.size()-1)*dx,y2));  //slope
        }
    }
    public void setTimeseries(ExpressionTimeSeries ts){
        this.timeSeries = ts;
    }
    public ExpressionTimeSeries getTimeseries(){
        return timeSeries;
    }
    public void setDimension(Dimension d){
        this.dim = d;
    }
    public void setLabelCells(boolean label){
        labelCells = label;
    }
    public void setYScale(ValueRange r){
        yScale = r;
    }
   
    public void setOnset(ExpressionOnset[] onset){
        for (int i=0 ; i<onset.length; ++i){
            setAnnotation(String.format("Onset%d",i),onset[i]);
        }
    }
    public void setOnsetLabels(boolean l){
        this.onsetLabels = l;
    }
    public void setAnnotation(String name,Object annotation){
        annotations.put(name,annotation);
    }
    public void removeAnnotaion(String name){
        annotations.remove(name);
    }
    Dimension dim; // the size of the buffered image
    float dx;    
    float dy;
    float yMin;
//    int window = 50;
    boolean labelCells=true;
    static int nZones = 6;
    ExpressionTimeSeries timeSeries;
 //   ExpressionOnset[] onList;
    boolean onsetLabels=false;

    BufferedImage image;
    ValueRange yScale;  // the y scale of the image
    HashMap<String,Object> annotations = new HashMap<String,Object>();
}
