/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SulstonEmbryo;

import org.rhwlab.expression.CellDataTimeSeries;

import java.awt.Dimension;
import java.awt.Color;
import java.awt.Graphics2D;

import java.awt.image.BufferedImage;

import java.util.List;
/**
 *
 * @author gevirl
 */
public class MultiEmbryoTimeSeriesImage {
    public MultiEmbryoTimeSeriesImage(EmbryoCell sulston,EmbryoCell[] leaves ){
        setSulstonLeaf(sulston);
        setLeaves(leaves);
    }
    public BufferedImage getIMage(){
        image = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, dim.width, dim.height);
        dx = (float)dim.width/(float)sulstonTimeSeries.size();
        
        // draw axis and vertical cell division lines
        
        // add each time series to the image
        for (EmbryoCell leaf : leaves){
            CellDataTimeSeries timeSeries = leaf.getExpTimeSeries();
            drawTimeSeries(g2,timeSeries);
        }
        return image;
    }
    private void drawTimeSeries(Graphics2D g2,CellDataTimeSeries timeSeries){
        
    }
    final public void setDimension(Dimension dim){
        this.dim = dim;
    }
    final public void setSulstonLeaf(EmbryoCell sulston){
        this.sulstonLeaf = sulston;
        this.sulstonTimeSeries = this.sulstonLeaf.getExpTimeSeries();
    }
    final public void setLeaves(EmbryoCell[] leaves){
        this.leaves = leaves;
        
        // calculate the vertical scale by finding global minimum and maximum 
        yMin = Float.MAX_VALUE;
        yMax = Float.MIN_VALUE;
        for (EmbryoCell leaf : leaves){
            CellDataTimeSeries timeSeries = leaf.getExpTimeSeries();
            int min = timeSeries.getMin();
            int max = timeSeries.getMax();
            if (min < yMin) yMin = min;
            if (max > yMax) yMax = max;
        }
        dy = (float)dim.height/(yMax-yMin);
    }
    Dimension dim;  // the size of the generated BufferedImage
    EmbryoCell sulstonLeaf;  // the Sulston leaf of the branch to map all the time series onto
    EmbryoCell[] leaves;  // the leaves of the embryo branches to place on the image
    
    CellDataTimeSeries sulstonTimeSeries;
    float dx;
    float dy;
    float yMin;
    float yMax;
    BufferedImage image;
}
