/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.beans.EmbryoCell;
/**
 *
 * @author gevirl
 */

// encapsulates the concept of an expression time series that can have an onset of expression
// onset can be null - indicates there is no onset
public class OnsetExpTimeSeries extends ExpressionTimeSeries implements ChangeListener {
    public OnsetExpTimeSeries(ExpressionTimeSeries ets) {
        super(ets);
    }
    // builds the expression time series for the given cell
    // expression type is a property of the cell
    public static OnsetExpTimeSeries factory(EmbryoCell cell) {
        ExpressionTimeSeries ets = ExpressionTimeSeries.factory(cell);       
        OnsetExpTimeSeries ret = new OnsetExpTimeSeries(ets);
        int n = ret.getSeriesCount();
        for (int i=0 ; i<n ; ++i){
            CellDataTimeSeries cdts  = (CellDataTimeSeries)ret.getSeries(i); 
            cdts.addOnsetListener(ret);
        }
        return ret;
    }

    public String getOnsetCell(){
        ExpressionOnset onset = getOnset();
        if (onset != null)
            return this.getLabel(onset.getOnset());
        else 
            return null;
    }
    public ExpressionOnset getOnset(){
        // look for an onset in one of the cells in this time series
        int n = this.getSeriesCount();
        for (int i=0 ; i<n ; ++i){
            CellDataTimeSeries cdts = (CellDataTimeSeries)this.getSeries(i);
            ExpressionOnset onset = cdts.getExprOnset();
            if (onset != null){
                return onset;
            }
        }
        return null;
    }

    final public CellDataTimeSeries setOnset(ExpressionOnset onset){
        
        // clear the current onset in this time series, if there is one already set
        // this also handles the situation when the onset is null and is being removed from the time series
        int n = this.getSeriesCount();
        for (int i=0 ; i<n ; ++i){
            CellDataTimeSeries clearing  = (CellDataTimeSeries)this.getSeries(i);
            ExpressionOnset curr = clearing.getExprOnset();
            if (curr != null) {
  //              System.out.printf("OnsetExpTimeSeries: clearing %s\n", clearing.cell.getName());
 //               clearing.clearOnset();
                clearing.setExprOnset(null,true);
                if (onset==null){
                    ChangeEvent event = new ChangeEvent(this);
                    for (ChangeListener listen : listeners){
                        listen.stateChanged(event);
                    }                    
                    return clearing;
                }
                break;
            }
        }
        
        // set the onset in the correct simple time series
        CellDataTimeSeries cdts = null;
        if (onset != null) {
            TimeSeries ts = this.findSeries(onset.getOnset());    
            cdts = (CellDataTimeSeries)ts;
            if (cdts != null){
                // remove any onsets in this cell time series and  in children cell time series
                cdts.clearOnset();   
                
                // add the onset to this cell
                cdts.setExprOnset(onset,true);
            }

        }
        // notify listeners
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listen : listeners){
            listen.stateChanged(event);
        }
        return cdts;
    }
    public void addListener(ChangeListener listen){
        listeners.add(listen);
    }
    ArrayList<ChangeListener> listeners = new ArrayList<ChangeListener>();

    @Override
    public void stateChanged(ChangeEvent e) {
                ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listen : listeners){
            listen.stateChanged(event);
        }
    }

}