/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression;
import org.rhwlab.beans.EmbryoCell;
import flanagan.analysis.Regression;

/**
 *
 * @author gevirl
 */

public class ExpressionTimeSeries extends CompositeTimeSeries {
    // an empty time series with just a label - used by the factory
    public ExpressionTimeSeries(String label){
        super(label);

    }
    // construct from some other expression time series
    public ExpressionTimeSeries(ExpressionTimeSeries ets){
        this(ets.label);
        this.list = ets.list;
        this.leaf = ets.leaf;
    }
    // get the cell which contains the data at index
    public EmbryoCell getCellByIndex(int index){
        String name = this.getLabel(index);
        return this.getCell(name);
    }
    
    // get the cell in this time series with the given name
    // works from the leaf up
    public EmbryoCell getCell(String cellName){
       if (leaf.getName().equals(cellName))  return leaf;
       return leaf.getParentByName(cellName);
    }
    
    // build a time series from the leaf to the root
    // builds the time series from the back to the front recursively
    // uses the expression type that is in the embryo
    public static ExpressionTimeSeries factory(EmbryoCell leaf){
        if (leaf == null){
            int iausfhd=0;
        }
        ExpressionTimeSeries ret = new ExpressionTimeSeries(leaf.getName());
        ret.setLeaf(leaf);
        CellDataTimeSeries cdts = leaf.getExpTimeSeries();
        ret.insert(cdts);  // use the time series of the leaf cell
        
        // is there a parent cell to add
        Object obj = leaf.getParent();
        if (obj instanceof EmbryoCell){
            EmbryoCell parent = (EmbryoCell)obj;
            ExpressionTimeSeries parTS = ExpressionTimeSeries.factory(parent);
            ret.insert(parTS);            
        } 
        return ret;
    }
    // construct time series from the given expression type, not the type in the embryo
    public static ExpressionTimeSeries factory(EmbryoCell leaf,String type){
     
        ExpressionTimeSeries ret = new ExpressionTimeSeries(leaf.getName());
        ret.setLeaf(leaf);
        CellDataTimeSeries cdts = new CellDataTimeSeries(leaf,type);
        ret.insert(cdts);  // use the time series of the leaf cell
        
        // is there a parent cell to add
        Object obj = leaf.getParent();
        if (obj instanceof EmbryoCell){
            EmbryoCell parent = (EmbryoCell)obj;
            ExpressionTimeSeries parTS = ExpressionTimeSeries.factory(parent);
            ret.insert(parTS);            
        } 
        return ret;
    }    
    public void setLeaf(EmbryoCell cell){
        this.leaf = cell;
    }
    public EmbryoCell getLeaf(){
        return leaf;
    }
    EmbryoCell leaf;
   
}