/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression;
import org.rhwlab.beans.EmbryoCell;

/**
 *
 * @author gevirl
 */

// this time series is for calculating rates of expression onset
// it averages over all the leave's time series, the  data points later than the onset
public class AverageExpTimeSeries extends CompositeTimeSeries {
    public AverageExpTimeSeries(String label){
        super(label);
    }
    
    // construct the time series by averaging all expression points that come after the onset
    // the onset is set in the provided cell
    static public AverageExpTimeSeries factory(EmbryoCell onsetCell){
        int onset = onsetCell.getExpTimeSeries().getExprOnset().getOnset();
        // begin this time series with the time point up to the onset cell
        ExpressionTimeSeries beforeTS = ExpressionTimeSeries.factory(onsetCell);
        int beforeSZ = beforeTS.size();
        AverageExpTimeSeries ret = new AverageExpTimeSeries(onsetCell.getName());
        
        // how many time points after the onsetCell are needed to be averaged?
        int n = CompositeTimeSeries.window - (onsetCell.getEndTime()-onset);
        if (n > 0){
            // need to add some more time points to fill out the window

            int[] counts = new int[n];
            long[] totals = new long[n];
            for (int i=0 ; i<counts.length;++i){
                counts[i] = 0;
                totals[i]=0;
            }
        
            // build a time series for each leaf of the onset cell - these will be averaged - 
            // these time series could be shorter than n more time points
            EmbryoCell[] leaves = onsetCell.getLeaves();
            int maxSize =0 ;
            for (int i=0 ; i<leaves.length ; ++i){
                ExpressionTimeSeries tSeries = ExpressionTimeSeries.factory(leaves[i]);
                int tsSZ = tSeries.size();
                int[] values = tSeries.getInteger(beforeTS.size(),n);  // may return less than n points
                if (values.length>maxSize) maxSize = values.length;  // keep track of the longest array
                for (int j=0;j<values.length;++j){
                    totals[j] = totals[j] + values[j];
                    ++counts[j];
                }
            }
        
            // compute the average
            int[] ave = new int[maxSize];
            for (int i=0 ; i<ave.length;++i){
                ave[i] = (int)(totals[i]/counts[i]);
            }       
            ret.insert(new SimpleTimeSeries(ave,"after"));        
        }
        
        ret.insert(beforeTS);
        ret.expOnset = onsetCell.getExpTimeSeries().getExprOnset();
        return ret;
    }
    
    public RegressionResult doRegression(){
        return this.doRegression(expOnset.getOnset(), true);
    }
    
    ExpressionOnset expOnset;
}
