/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.density.estimator;

import java.util.Arrays;

/**
 *
 * @author gevirl
 */
public class SummaryStats {
    public SummaryStats(){
        
    }
    public double getMean(){
        double sum = 0.0;
        double[] x = estimator.getX();
        double[] p = estimator.getProb();
        for (int i=0 ; i<x.length ; ++i){
            sum = sum + x[i]*p[i];
        }
        return sum;
    }
    
    public double getMode(){
        double mode = Double.NaN;
        double maxP = Double.MIN_VALUE;
        double[] x = estimator.getX();
        double[] p = estimator.getProb();
        for (int i=0 ; i<x.length ; ++i){
            if (p[i] > maxP){
                maxP = p[i];
                mode = x[i];
            }
        } 
        return mode;
    }
    public double[] quantiles(double[] qTiles){
        Arrays.sort(qTiles);
        double[] x = estimator.getX();
        double[] p = estimator.getProb();        
        double[] ret = new double[qTiles.length];
        int tile = 0;
        double sum = 0.0;
        for (int i=0 ; i<p.length ; ++ i){
            sum = sum + p[i];
            if (sum >= qTiles[tile]){
                ret[tile] = x[i];
                ++tile;
                if (tile == qTiles.length) break;
            }
        }
        return ret;
    }    
    public void setEstimator(Object obj){
        this.estimator = (Estimator)obj;
    }
    Estimator estimator;
}
