/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.density.estimator;

import java.io.File;
import java.io.PrintStream;

/**
 *
 * @author gevirl
 */
// compute marginal distributions for MCMC output
// MCMC output is demultiplexed into a directory
public class Marginals implements java.lang.Runnable{

    @Override
    public void run() {
        SummaryStats stats = new SummaryStats();
        stats.setEstimator(this.estimator);
        try{
            if (marginalDir != null){
                PrintStream stream = new PrintStream(outFile);
                stream.println("Name,Mode,Mean,Low,Median,High,Fraction");
                double[] tiles = {0.05,0.5,0.95};            
                File[] files = marginalDir.listFiles();
                for (File file : files){
                    if (file.getName().equals("MT13544_100_1_1_1_6")){
                        int ajsdfjis=0;
                    }
                    estimator.setFile(file);
                    estimator.init();
                    
                    double[] q = stats.quantiles(tiles);
                    double mean = stats.getMean();
                    double mode = stats.getMode();  

                    stream.printf("%s,%f,%f",file.getName(), mode,mean);
                    for (int i=0 ; i<tiles.length ; ++i){
                        stream.printf(",%f", q[i]);
                    }
                    stream.printf(",%f", estimator.getFraction());
                    stream.println();                
                }
                stream.flush();
            }
        } catch(Exception exc){
            exc.printStackTrace();
        }        
    }
    // set the marginal distributions directory
    public void setMarginalsDirectory(Object dir){
        if (dir instanceof String){
            marginalDir = new File((String)dir);
        } else {
            this.marginalDir = (File)dir;
        }
        
    } 
    // set the output file
    public void setOutputFile(Object obj){
        if (obj instanceof String){
            outFile = new File((String)obj);
        } else {
            outFile = (File)obj;
        }
    }
    public void setEstimator(Object obj){
        this.estimator = (Estimator)obj;
    }
    File marginalDir = null;
    File outFile;  
    Estimator estimator;
}
