/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.density.estimator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import weka.estimators.KernelEstimator;

/**
 *
 * @author gevirl
 */
// kernel density estimator, tailored to find more accurate zero values when data is all positive 
// flips the positive data onto the negative axis
// in order to get better zero estimate
public class FlippedKernel implements Estimator {
    public FlippedKernel(){
        
    }


    @Override
    public double[] getX() {
        int n = estimator.getNumKernels();
        double [] means = estimator.getMeans();
        int count = 0;
        for (int i=0 ; i<n;++i){
            if (means[i] >= 0.0){
                ++count;
            }
        }
        double[] ret = new double[count];
        int index = 0;
        for (int i=0 ; i<n ; ++i){
            if (means[i]>= 0.0){
                ret[index] = means[i];
                ++index;
            }
        }
        return ret;
    }

    @Override
    public double[] getProb() {
        double[] xs = this.getX();
        double[] p = new double[xs.length];
        for (int i=0 ; i<xs.length ; ++i){
            p[i] = estimator.getProbability(xs[i]);
        }
        return p;
    }

    @Override
    public void init() throws Exception {
        total = 0;
        na = 0;
        estimator = new KernelEstimator(precision);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            ++total;
            if (line.equalsIgnoreCase("NAN")){
                ++na;
            }else {
                double v = Double.valueOf(line);
                estimator.addValue(v, 1.0);
                estimator.addValue(-v, 1.0);
                
            }
            line = reader.readLine();
        }
        reader.close();        
    }
    
    @Override
    public void setFile(Object obj){
        if (obj instanceof String){
            file = (String)obj;
        } else {
            file = ((File)obj).getPath();
        }
    }
    @Override
    public void setPrecision(Object obj){
        if (obj instanceof Double){
            precision=(Double)obj;
        }
    } 
    public double getFraction(){
        return (double)na/(double)total;
    }
    int total;
    int na;
    double precision=.001;
    String file; 
    KernelEstimator estimator;
}
