/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import java.io.*;
import org.rhwlab.db.MySql;
import java.util.List;

import org.intermine.metadata.Model;
import org.intermine.webservice.client.core.ServiceFactory;
import org.intermine.webservice.client.services.ModelService;
import org.intermine.webservice.client.services.QueryService;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.Constraints;
import java.sql.ResultSet;
import java.util.*;
/**
 *
 * @author gevirl
 */
public class TF {
    // construct the TF from a current result set row
    public TF(ResultSet rs) throws Exception {
        this.sequenceName = rs.getString("Sequence");
        this.CGCName = rs.getString("CGC");
        this.region = new ChromosomeRegion(rs.getString("Chromosome"),rs.getInt("Start"),rs.getInt("End"));
    }
    static public List<Gene> getImagedTFs(MySql db) throws Exception {
        // get all the imaged TFs from the database
        ArrayList<Gene> TFs = new ArrayList<Gene>();
        String sql = 
            "select Sequence,CGC,Chromosome,Start,End from "+
            "(select * from TFs T,WBGenes W where T.`Sequence`= W.`Alias`) TF,"+
            "(select distinct S.RedSig,W.WBGene from Series S,WBGenes W where S.RedSig=W.Alias order by RedSig) I "+
            "where TF.WBGene=I.WBGene order by Chromosome,Start";
        ResultSet rs = db.execute(sql);
        while (rs.next()){            
            Gene gene = new Gene();
            gene.fromMySqlBySequence(db,rs.getString("Sequence"));
            TFs.add(gene);
        }
        return TFs;
    }
    static public List<Gene> getAllTFs(MySql db) throws Exception {
        // get all the TFs from the database
        ArrayList<Gene> TFs = new ArrayList<Gene>();
        String sql = 
            "Select Sequence from TFs";
        ResultSet rs = db.execute(sql);
        while (rs.next()){            
            Gene gene = new Gene();
            String seq = rs.getString("Sequence");
            gene.fromMySqlBySequence(db,seq);
            TFs.add(gene);
        }
        return TFs;        
    }
    // load the database using an input file to identify the transcription factors
    // some of the data will be obtained from modENCODE
    static public void loadDB(MySql db,File file) throws Exception {
        ServiceFactory factory = new ServiceFactory(ROOT);
        Model model = factory.getModelService().getModel();
        QueryService service = factory.getQueryService();

        
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            if (line.charAt(0)!='#'){
                String[] tokens = line.split("\t");
                
                // get the WBGene name for the sequence id
                String sql = String.format("Select * from WBGenes where Alias=\'%s\'",tokens[0]);
                ResultSet rs = db.execute(sql);
                String gene = null;
                if (rs.next()) {
                    gene = rs.getString("WBGene");
                } else {
                    System.out.println(tokens[0]);
                }
                
                PathQuery query = new PathQuery(model);
                // Add views

                query.addViews("Gene.chromosomeLocation.start",
                "Gene.chromosomeLocation.end",
                "Gene.chromosome.primaryIdentifier");

                // Add orderby
                query.addOrderBy("Gene.chromosomeLocation.start", OrderDirection.ASC);

                // Add constraints and you can edit the constraint values below
                query.addConstraint(Constraints.eq("Gene.primaryIdentifier", gene));
                
                List<List<String>> result = service.getAllResults(query);
                
                if (!result.isEmpty()){
                    List<String> row = result.get(0);
                    sql = String.format("Insert into TFs (Sequence,CGC,Chromosome,Start,End) values (\'%s\',\'%s\',\'%s\',%s,%s)",
                        tokens[0],tokens[1],row.get(2),row.get(0),row.get(1));
                    db.execute(sql);
                } else {
                    System.out.printf("%s\n", tokens[0]);
                }    
            }
            line = reader.readLine();
        }
    }
    
    public String getSequenceName(){
        return sequenceName;
    }
    public String getCGCName(){
        return CGCName;
    }
    public int getStart(){
        return region.getStart();
    }
    public int getEnd(){
        return region.getEnd();
    }
    public String getChromosome(){
        return region.getChromosome();
    }
    public ChromosomeRegion getRegion(){
        return region;
    }
    public void dump(PrintStream stream){
        stream.printf("%s,%s,",this.sequenceName,this.CGCName);
        region.dump(stream);
    }
    static public void main(String[] args){
        try {
            MySql db = MySql.getMySql();
            TF.loadDB(db, new File(args[0]));
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }
    private static final String ROOT = "http://intermine.modencode.org/release-27/service";
    
    String sequenceName;
    String CGCName;
    ChromosomeRegion region;
}
