/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import jxl.*;
import org.rhwlab.db.MySql;
import java.sql.*;
import java.text.SimpleDateFormat;

/**
 *
 * @author gevirl
 */
public class Strain {
    public void fromSheetRow(Sheet sheet,int row){
        Cell[] heads = sheet.getRow(0);
        Cell[] rowCells = sheet.getRow(row);
        for (int i=0 ; i<heads.length ; ++i){
            String head = heads[i].getContents();
            if (head.equals("Strain Designation")){
                this.name = rowCells[i].getContents();
            } else if (head.equals("Genotype (and plate position)")){
                this.genotype = rowCells[i].getContents();
            } else if (head.equals("Reporter Allele")) {
                this.reporterAllele = rowCells[i].getContents();
            } else if (head.equals("Reporter Construct")){
                this.construct = rowCells[i].getContents();
            } else if (head.equals("Creator")){
                this.createdBy = rowCells[i].getContents();
            } else if (head.equals("Entry Date")){
                if (rowCells[i] instanceof jxl.DateCell){
                    DateCell dateCell = (DateCell)rowCells[i];
                    this.date = dateCell.getDate();
                } else {
                    this.date = null;
                }
            } else if (head.equals("Parents or Lineage Alleles")){
                this.lineageAllele = rowCells[i].getContents();
            }
        }
    }
    public void toMySql(MySql db) throws Exception {
        // is there a strain record in the db?
        String sql = String.format("Select * from Strains where Strain=\'%s\'", this.name);
        ResultSet  rs = db.execute(sql);
        if (!rs.next()){
            // add a new record for this strain
            sql = String.format("Insert into Strains (Strain) values (\'%s\')", this.name);  
            db.execute(sql);
        }
        // update the values
        if (this.genotype != null){
            sql = String.format("Update Strains set Genotype=\'%s\' where Strain=\'%s\'",replace(this.genotype),this.name);
            db.execute(sql);            
        }
        if (this.construct != null){
            sql = String.format("Update Strains set Construct=\'%s\' where Strain=\'%s\'",this.construct,this.name);
            db.execute(sql);               
        }
        if (this.createdBy != null){
            sql = String.format("Update Strains set CreatedBy=\'%s\' where Strain=\'%s\'",this.createdBy,this.name);
            db.execute(sql);               
        } 
        if (this.date != null){
            sql = String.format("Update Strains set EntryDate=\'%s\' where Strain=\'%s\'",this.getDateString(),this.name);
            db.execute(sql);               
        } 
        if (this.lineageAllele != null){
            sql = String.format("Update Strains set LineageAllele=\'%s\' where Strain=\'%s\'",this.lineageAllele,this.name);
            db.execute(sql);               
        }   
        if (this.reporterAllele != null){
            sql = String.format("Update Strains set ReportAllele=\'%s\' where Strain=\'%s\'",this.reporterAllele,this.name);
            db.execute(sql);               
        }         

    }
    static public Strain fromMySql(MySql db,String strainName) throws Exception {
        // is the strain in the db
        String sql = String.format("Select * from Strains where Strain=\'%s\'",strainName);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            Strain strain = new Strain();
            strain.name = strainName;
            strain.genotype = rs.getString("Genotype");
            strain.construct = rs.getString("Construct");
            strain.createdBy = rs.getString("CreatedBy");
            strain.lineageAllele = rs.getString("LineageAllele");
            strain.reporterAllele = rs.getString("ReportAllele");
            strain.date = rs.getDate("EntryDate");
            return strain;
        }
        return null;
    }
    static public Strain fromMySql(String strainName) throws Exception {
        // is the strain in the db
        String sql = String.format("Select * from Strain where StrainID=\'%s\'",strainName);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            Strain strain = new Strain();
            strain.name = strainName;
            strain.genotype = rs.getString("Genotype");
            strain.construct = rs.getString("ConstructType");
            strain.constructID = rs.getString("ConstructID");
            strain.createdBy = rs.getString("Creator");
            strain.lineageAllele = rs.getString("LineageAllele");
            strain.reporterAllele = rs.getString("ReporterAllele");
            strain.date = rs.getDate("EntryDate");
            return strain;
        }
        return null;
    }    
    private String replace(String s){
        return s.replaceAll("'", "\'\'");
        
    }
    public String getName(){
        return this.name;
    }
    public java.util.Date getDate(){
        return this.date;
    }
    public String getDateString(){
        if (this.date != null)
            return outFormat.format(this.date);
        else
            return "";
    }
    public String getGenotype(){
        return genotype;
    }
    public String getReportAllele(){
        return this.reporterAllele;
    }
    public String getLineageAllele() {
        return this.lineageAllele;
    }
    public String getCreatedBy(){
        return this.createdBy;
    }
    public String getConstructType(){
        return this.construct;
    }
    public String getConstructID(){
        return this.constructID;
    }
    public String getConstruct(){
        return String.format("%s (%s)",this.constructID,this.construct);
    }
    String name;
    java.util.Date date;
    String genotype;
    String reporterAllele;
    String lineageAllele;
    String construct;
    String constructID;
    String createdBy;   
    
    static SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd");
}
