/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

/**
 *
 * @author gevirl
 */
public class NarrowPeakBedRecord implements Comparable {

    String chromo;
    int start;
    int end;
    String name;
    int score;
    String strand;
    double signal;
    double pValue;
    double qValue;
    int peak;

    
    public NarrowPeakBedRecord(String rec) {
        String[] tokens = rec.split("\t");
        chromo = tokens[0];
        start = Integer.valueOf(tokens[1]);
        end = Integer.valueOf(tokens[2]);
        name = tokens[3];
        score = Integer.valueOf(tokens[4]);
        strand = tokens[5];
        signal = Double.valueOf(tokens[6]);
        pValue = Double.valueOf(tokens[7]);
        qValue = Double.valueOf(tokens[8]);
        peak = Integer.valueOf(tokens[9]);

    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStage() {
        int i = name.indexOf("_");
        return name.substring(i + 1);
    }

    public String getTF() {
        return name.split("_")[0];
    }

    public String getChromosome() {
        return chromo;
    }

    public Integer getStart() {
        return start;
    }

    public Integer getEnd() {
        return end;
    }

    public Integer getPeakOffset() {
        return peak;
    }

    public int getPeakLocation() {
        return getStart() + getPeakOffset();
    }



    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(chromo);
        builder.append("\t");
        builder.append(start);
        builder.append("\t");
        builder.append(end);
        builder.append("\t");
        builder.append(name);
        builder.append("\t");
        builder.append(score);
        builder.append("\t");
        builder.append(strand);
        builder.append("\t");
        builder.append(signal);
        builder.append("\t");
        builder.append(pValue);
        builder.append("\t");
        builder.append(qValue);
        builder.append("\t");
        builder.append(peak);
        return builder.toString();
    }

    @Override
    public int compareTo(Object o) {
        NarrowPeakBedRecord other = (NarrowPeakBedRecord) o;
        int ret = this.getChromosome().compareTo(other.getChromosome());
        if (ret == 0) {
            ret = this.getStart().compareTo(other.getStart());
            if (ret == 0) {
                ret = this.getEnd().compareTo(other.getEnd());
            }
            if (ret == 0){
                ret = this.name.compareTo(other.name);
            }
        }
        return ret;
    }
}
