/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

/**
 *
 * @author gevirl
 */
public class ChipSeqBedRecord extends NarrowPeakBedRecord {

    String cluster = null;
    String target = null;
    int clusterSize;

    public ChipSeqBedRecord(String record) {
        super(record);
        String[] tokens = record.split("\t");
        if (tokens.length >= 13) {
            cluster = tokens[10];
            clusterSize = Integer.valueOf(tokens[11]);
            target = tokens[12];
        } else if (tokens.length >= 12) {
            cluster = tokens[10];
            target = tokens[11];
        }
    }

    public ChipSeqBedRecord toPointCoordinates() {
        ChipSeqBedRecord ret = new ChipSeqBedRecord(this.toString());  // clone the record
        int coord = getStart() + getPeakOffset();
        ret.start = coord;
        ret.end = coord;

        return ret;
    }

    public void setClusterSize(int s) {
        this.clusterSize = s;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public void setCluster(String c) {
        this.cluster = c;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        if (cluster != null) {
            builder.append("\t");
            builder.append(this.cluster);
            builder.append("\t");
            builder.append(this.clusterSize);
            builder.append("\t");
            builder.append(this.target);
        }
        return builder.toString();
    }

}
