/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.math3.ml.clustering.Clusterable;

/**
 *
 * @author gevirl
 */
    public class BindSite implements Clusterable {
        public BindSite(String[] tokens){
            this.tokens = tokens;
            this.coord[0] = location();
        }
        final public double location(){
            int s = Integer.valueOf(tokens[1]);
            int e = Integer.valueOf(tokens[2]);
            return (((double)s + (double)e )/2.0);        
        }        
        public double getCoord(){
            return coord[0];
        }
        @Override
        public double[] getPoint() {
            return coord;
        }

        public double getScore(){
            return Double.valueOf(this.tokens[6]);
        }
        
        @Override
        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + Arrays.deepHashCode(this.tokens);
            hash = 47 * hash + Arrays.hashCode(this.coord);
            return hash;
        }
        public boolean equals(Object o){
            BindSite bs = (BindSite)o;
         
            if (!bs.tokens[0].equals(this.tokens[0])){
                return false;
            }
            if (!bs.tokens[1].equals(this.tokens[1])){
                return false;
            }
            if (!bs.tokens[2].equals(this.tokens[2])){
                return false;
            }  
            if (!bs.tokens[4].equals(this.tokens[4])){
                return false;
            }
            return true;
        }
        public void print(PrintStream stream){
            stream.printf("%s", tokens[0]);
            for (int i=1 ; i<tokens.length ; ++i){
                stream.printf("\t%s", tokens[i]);
            }
            stream.println();
        }
        public void shortPrint(PrintStream stream){
            stream.printf("chr%s\t%s\t%s\t%s\t0\t%s\t%s\t%s\t0,0,0\n",tokens[0],tokens[1],tokens[2],tokens[14],tokens[5],tokens[1],tokens[2]);
        }
        String[] tokens;
        double[] coord = new double[1];        
    }
