/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.beans;
import java.util.*;
import javax.swing.tree.DefaultMutableTreeNode;
import java.io.*;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Imaged;
import org.rhwlab.expression.ExpressionTimeSeries;

/**
 *
 * @author gevirl
 */
public class SeriesEmbryo implements org.rhwlab.universalimaging.Embryo {
    /* 
     * construct the embryo using the database metadata
     * only build the embryo to the edited time point
     */
    public SeriesEmbryo(String seriesID)throws Exception {
        this(seriesID,"zblot");
    }
    public SeriesEmbryo(String seriesID,String type) throws Exception {
        this(new SeriesMetaData(seriesID),seriesID,type);
    }
    public SeriesEmbryo(MySql db,String seriesID,String type) throws Exception {
        this(new SeriesMetaData(db, seriesID),seriesID,type);     
    }
    public SeriesEmbryo(Imaged md,String seriesID,String type) throws Exception {
        this(nucleiFactory(seriesID,new File(md.getEditZip())),new Integer(md.getEditedTimePoints()),type);
        this.metaData = md;
    }
    static private  SeriesNuclei nucleiFactory(String seriesID,File zip) throws Exception {
        SeriesNuclei nucs = new SeriesNuclei(seriesID);
        nucs.readZipFile(zip);
        return nucs;
    }
    public SeriesEmbryo(SeriesNuclei series,Integer limit,String type){
        this(new DefaultMutableTreeNode(series.getID()),series,limit,type);
    }
    public SeriesEmbryo(DefaultMutableTreeNode r,SeriesNuclei series,Integer limit,String type){
        this.root = r;
        seriesNuclei = series;
        this.expressionType =  type;
        this.limit = limit;
        roots = new TreeSet<EmbryoCell>(new Comparator<EmbryoCell>(){
            public int compare(EmbryoCell c1,EmbryoCell c2){
                return -c1.compareTo(c2);
            }
        });        
        // make a root cell for any nucleus that does not have a parent and is not a polar body
        for (int i=1 ; i<=series.getMaxTime() ; ++i){
            TimePointNuclei nucsAtTime = series.getNucleiAtTime(i);
            if (nucsAtTime == null) continue;
            ArrayList<TimePointNucleus> nuclei = nucsAtTime.getNuclei();
            
            for (TimePointNucleus nuc : nuclei){
                if (nuc == null) continue;
                if (nuc.predecessor != -1) continue;  //only need to process root cells
                String name = nuc.getName();
                
                if (name.startsWith("P")||name.startsWith("A")||name.startsWith("E")||name.startsWith("D")||name.startsWith("C")||name.startsWith("M")){
                //if (!name.startsWith("Nuc") && !name.startsWith("polar")&& !name.equals("") && !name.equals("nill")) {
                    // make a root cell for this nucleus
                    EmbryoCell rootCell = new EmbryoCell(this,nuc,limit,type);
                    roots.add(rootCell);
                }
            }            
        } 
        for (EmbryoCell cell : roots){
            root.add(cell);
        }
        
        // compute the background expression 
        Double back = 0.0;
        int count = 0;
        for (int t=0 ; t<5 ; ++t){
            EmbryoCell[] cells = this.getCellsAtTime(t);
            for (EmbryoCell cell : cells){
                TimePointNucleus nuc = cell.getNucleusAtTime(t);
                back = back + nuc.getMeanExpression();
                ++count;
            }
        }
        background = (int)(back/count);
        int uhsd=0;
    } 

    static public TreeSet<String> commonLeafSet(SeriesEmbryo emb1,SeriesEmbryo emb2){
        SeriesEmbryo[] embs = new SeriesEmbryo[2];
        embs[0] = emb1;
        embs[1] = emb2;
        return commonLeafSet(embs);
    }
    // determine the common set of leaves in a group of embryos
    static public TreeSet<String> commonLeafSet(SeriesEmbryo[] embryos){
        if (embryos.length==0) return null;
        
        TreeSet<String> ret = new TreeSet<String>();
        EmbryoCell[] leaves = embryos[0].getAllLeaves();
        for (EmbryoCell leaf : leaves){
            EmbryoCell cell = leaf;
            for (int i=1 ; i<embryos.length ; ++i){
                SeriesEmbryo embryo = embryos[i];
                 cell = embryo.findCellOrAncestor(cell);
            }

            if (cell != null) ret.add(cell.getName());
        }
        return ret;
    }
    public EmbryoCell findCellOrAncestor(EmbryoCell toFind){
        for (EmbryoCell root : roots){
            EmbryoCell cell = root.getDescendent(toFind.getName());
            if (cell != null){
                return cell;
            }
        }
        toFind = toFind.getParentCell();
        if (toFind != null){
            return this.findCellOrAncestor(toFind);
        }
        return null;
    }
    // determine the maximum sulston time over all the  cells at the given index time
    // each  cell could have a different sulston time at the given index time
    // this routine returns the maximum of those sulston times
    public float sulstonTime(int indexTime) throws Exception {
        EmbryoCell[] cells = this.getCellsAtTime(indexTime);
        float maxSulstonTime = Float.MIN_VALUE;
        EmbryoCell maxcell = null;
        for (EmbryoCell cell : cells){
            float sulstonTime = cell.toSulston(indexTime);
            if (sulstonTime > maxSulstonTime){
                maxSulstonTime = sulstonTime;
                maxcell = cell;
            }
        }
        System.out.printf("Max Cell: %s\n", maxcell);
        return maxSulstonTime;
    }
    public double maxSulstonTime()throws Exception {
        double ret = Double.MIN_VALUE;
        for (EmbryoCell leaf : this.getAllLeaves()){
            double t = leaf.getSulstonEnd();
            if (t > ret ){
                ret = t;
            }
        }
        return ret;
    }
    // save the embryo structure to the database
    public void saveToDB(MySql db) throws Exception {
        // save each root
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell cell = (EmbryoCell)root.getChildAt(i);
            cell.saveToDB(db,seriesNuclei.getID());
        }
        
    }
    // save all the linkages in this embryo into the database
    // this is used to build the linkages table using the sulston embryo
    public void saveLinkage(MySql db)throws Exception {
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell cell = (EmbryoCell)root.getChildAt(i);
            cell.saveLinkage(db);
        }        
    }

    // count the nuclie used in the embryo
    public long countNuclei(){
        int n = root.getChildCount();
        long count = 0;
        for (int i=0 ; i<n ; ++i){
            EmbryoCell child = (EmbryoCell)root.getChildAt(i);
            count = count + child.countNuclei();
        }
        return count;
    }

    public DefaultMutableTreeNode getRoot(){
        return root;
    }
    // get the maximum expression value in this embryo
    @Override
    public int maxExpression(){
        int max = Integer.MIN_VALUE;
        EmbryoCell[] cells = this.getAllCells();
        for (EmbryoCell cell : cells){
            int v  = cell.getExpTimeSeries().getMax();
            if (v > max) {
                max = v;
            }
        }
        return max;
    }
    // get the mimimum expression value from all the leaf time series
    public int minExpression(){
        if (minExp == null){
            int min = Integer.MAX_VALUE;
            EmbryoCell[] cells = this.getAllCells();
            for (EmbryoCell cell : cells){
                int v  = cell.getExpTimeSeries().getMin();
                if (v < min) {
                    min = v;
                }
            }
            minExp = new Integer(min);
        }
        return minExp;
    }    
    public int expressionMax(){
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        EmbryoCell[] leaves = this.getAllLeaves();
        for (EmbryoCell leaf : leaves){
            ExpressionTimeSeries timeSeries = ExpressionTimeSeries.factory(leaf);
            int vMax = timeSeries.getMax();
            int vMin = timeSeries.getMin();
            if (vMax > max) {
                max = vMax;
            }
            if (vMin < min){
                min = vMin;
            }
        } 
        return max;
    }
    // get all cells in this embryo
    public EmbryoCell[] getAllCells(){
        TreeSet<EmbryoCell> ret = new TreeSet<EmbryoCell>();
        for (EmbryoCell r : roots){
            ret.addAll(r.getAllCells());
        }
        return ret.toArray(new EmbryoCell[0]);
    }
    // a set of all cells in a group of embryos in a subtree below a given root cell
    static public TreeSet<String> getAllCells(ArrayList<SeriesEmbryo> embList,String root){
        TreeSet<String> ret = new TreeSet<String>();
        for (SeriesEmbryo emb : embList){
            EmbryoCell r = emb.getCell(root);
            TreeSet<EmbryoCell> cells = r.getAllCells();
            for (EmbryoCell cell : cells){
                ret.add(cell.getName());
            }
        }
        return ret;
    }
    // return the names of all the leaf cells in this embryo
    public EmbryoCell[] getAllLeaves(){
        ArrayList<EmbryoCell> cellList = new ArrayList<EmbryoCell>();
 //       EmbryoCell[] roots = getRoots();
        for (EmbryoCell r : roots){
            EmbryoCell[] leaves = r.getLeaves();
            
            for (EmbryoCell l : leaves){
                cellList.add(l);
            }
        }
        return cellList.toArray(new EmbryoCell[0]);
    }
    public EmbryoCell[] getRoots(){
        return roots.toArray(new EmbryoCell[0]);
    }
    // get subtree(s) in the request lineage
    public EmbryoCell[] getLineages(String lineage,SulstonEmbryo sulston){
        // first check if the lineage requested in is any of the roots of this embryo
        EmbryoCell line = this.getCell(lineage);
        if (line != null) {
            EmbryoCell[] ret = new EmbryoCell[1];
            ret[0] = line;
            return ret;
        }
        
        // return all the roots that are children of the requested lineage using the sulston embryo to decide
        ArrayList<EmbryoCell> childList = new ArrayList<EmbryoCell>();
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell child = (EmbryoCell)root.getChildAt(i);
            if (sulston.hasChild(child.getName())){
                childList.add(0,child);
            }
        }
        return childList.toArray(new EmbryoCell[0]);
    }  
    // find the leaf in this embryo that best matches the supplied cell
    public EmbryoCell nearestLeaf(EmbryoCell cell){
        for (EmbryoCell r : roots) {
            EmbryoCell nearest = r.nearestLeaf(cell);
            if (nearest!= null){
                return nearest;
            }
        }
        return null;
    }
    // check each root cell for the name being searched
    public EmbryoCell getCell(String cellName){
        // if the root is a cell
        if (root instanceof EmbryoCell){
            return ((EmbryoCell)root).getDescendent(cellName);
        }
        // search all the subtrees
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell child = (EmbryoCell)root.getChildAt(i);
            EmbryoCell ret = child.getDescendent(cellName);
            if (ret != null) return ret;
        }
        return null;
    }
    // report the maximum number of children found in any cell
    public int maxChildren(){
        int max = 0;
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell child = (EmbryoCell)root.getChildAt(i);
            int count = child.maxChildren();
            if (count > max ) max = count;
        }
        return max;
    }
    public void setExpressionType(String type){
        expressionType = type;
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell cell = (EmbryoCell)root.getChildAt(i);
            cell.setExpressionType(type);
        }
    }
    
    // dump the entire embryo series data to a file in text format
    public void dump(PrintWriter writer){
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell cell = (EmbryoCell)root.getChildAt(i);
            cell.dump(writer);
            writer.flush();
            int sahdfiusa=0;
        }
    }

    public String getID(){
        return seriesNuclei.getID();
    }
     
    // sum the total amount of expression for all the cells in the subtree rooted at this cell at a given time
    public CummulativeExpression totalExpression(MySql db,int time) {

        EmbryoCell[] cells = this.getCellsAtTime(time);
        double sulstonTime=0;
        double exp = 0.0;
        for (EmbryoCell cell : cells){
            try {

                sulstonTime = sulstonTime + cell.toSulston(time);
            }catch (Exception exc){
                exc.printStackTrace();  // crash and burn
                System.exit(time);
            }
            
//            int[] expressions = cell.getExpression(this.expressionType);
 //           int index = expressions.length + time - cell.endTime - 1;
            
            exp = exp + cell.backgroundCorrectedExpression(time, background);
        }
        if (exp<1.0) exp = 1.0;
 //       exp = exp / cells.length;
        return new CummulativeExpression(sulstonTime/cells.length,cells.length,exp);
    }    
    public EmbryoCell[] getCellsAtTime(int time){
        int n = root.getChildCount();
        ArrayList<EmbryoCell> ret = new ArrayList<EmbryoCell>();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell cell = (EmbryoCell)root.getChildAt(i);
            ArrayList<EmbryoCell> cells = EmbryoCell.getCellsAtTime(cell, time);
            ret.addAll(cells);
        }
        return ret.toArray(new EmbryoCell[0]);
    }
    public ArrayList<Integer> cellCountByTime(){
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int endtime = this.getEndTime();
        for (int i=1 ; i<=endtime ; ++i){
            EmbryoCell[] cells = this.getCellsAtTime(i);
            ret.add(new Integer(cells.length));
        }
        return ret;
    }   
    public Double[] timeByCellCounts(){
        ArrayList<Integer> countsByTime = this.cellCountByTime();
        int N = 600;
        Double[] times = new Double[N];
        times[0] =new Double(0.0);
        int firstTime =0;
        int count = countsByTime.get(firstTime);
        int maxCount = 0;
        for (int t=1 ; t<countsByTime.size() ; ++t){
            int current = countsByTime.get(t);
            if (maxCount < current) maxCount = current;
            if (count != current){
                times[count] = new Double((firstTime + t -1)/2.0);
                firstTime = t;
                count = current;
            }
        }
        // interpolate the missing cell counts
        for (int c=0 ; c<=maxCount ;++c){
            if (times[c]==null){
                // look ahead fro a non null entry
                int last = c+1;
                while (times[last]==null){
                    ++last;
                }
                double inc = (double)(times[last]-times[c-1])/(double)(last-c+1);
                while (c < last){
                    times[c] = new Double(times[c-1]+inc);
                    ++c;
                }
            }
        }
        
        return times;       
    }
    public EmbryoCell[] getCellsAtTimePlane(int time,int plane,double zRes){
        EmbryoCell[] cellsAtTime = this.getCellsAtTime(time);
        ArrayList<EmbryoCell> cells = new ArrayList<EmbryoCell>();
        for (EmbryoCell possible : cellsAtTime){
            if (possible.onPlane(time,plane,zRes)){
                cells.add(possible);
            }
        }
        return cells.toArray(new EmbryoCell[0]);
    }
    public int getEndTime(){
        return limit;
    }
    public String getType(){
        return this.expressionType;
    }
    public String getTitle(){
        return String.format("%s(%s)",this.getID(),this.metaData.getConstructType());
    }
    public static void reportSeries(SeriesEmbryo embryo)throws Exception {
            System.out.print("Cell\tTime\tExpression\n");
            EmbryoCell[] cells = embryo.getAllCells();
            for (EmbryoCell cell : cells){
                int[] exps = cell.getExpressionValues();
                int i=0;
                for (int time = cell.getStartTime() ; time<=cell.endTime ; ++time){
                    float sultonTime = cell.toSulston(time);
                    System.out.printf("%s\t%f\t%d\n",cell.getName(),sultonTime,exps[i]);
                    ++i;
                }
            }
        
    }
    static public void main(String[] args)throws Exception {
        SulstonEmbryo sulton = new SulstonEmbryo();
        SeriesEmbryo embryo = new SeriesEmbryo("20080606_hlh-1_6B4_4_L1");
        EmbryoCell cell = embryo.getCell("Capaaa");
        sulton.sulstonize(embryo);
        reportSeries(embryo);
    }
    
    TreeSet<EmbryoCell> roots;
    DefaultMutableTreeNode root;  // the children of this root are EmbryoCell objects
    String expressionType;  // which expression calculation should be used for this embryo
    SeriesNuclei seriesNuclei;  // the nuclei used to build this embryo
    int limit;  // the endtime for the embryo structure
    int background;
    Integer minExp = null;
    Imaged metaData;




}