/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.beans;
import java.io.PrintStream;
import org.rhwlab.db.MySql;
import java.util.HashMap;
import org.rhwlab.expression.*;
/**
 *
 * @author gevirl
 */
// extends a standard embryo structure to have functionality for expression onsets
public class ExpOnsetsEmbryo extends SeriesEmbryo {
    // construct a sulstonized embryo loaded with onsets from the database 
    public ExpOnsetsEmbryo(MySql db,String seriesID,String type,SulstonEmbryo sulston) throws Exception {
        this(db,seriesID,type);
        sulston.sulstonize(this);
        this.setExpressionOnsets();
    }
    public ExpOnsetsEmbryo(MySql db,String seriesID,String type) throws Exception {
        super(new SeriesMetaData(db, seriesID),seriesID,type);
        this.db = db;
    }    
    public ExpOnsetsEmbryo(MySql mysql,SeriesNuclei nucs,Integer limit,String type){
        super(nucs,limit,type);
        db = mysql;
    }
    public final void setExpressionOnsets() throws Exception{
        // get any onsets for this series from the database
            HashMap<String,ExpressionOnset> map = ExpressionOnset.getOnsetsFromDB(db, seriesNuclei.getID()); 
            setExpressionOnsets(map);
    }
    public HashMap<String,ExpressionOnset> getAllOnsets(){
        HashMap<String,ExpressionOnset> ret = new HashMap<String,ExpressionOnset>();
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell child = (EmbryoCell)root.getChildAt(i);
            getCellOnsets(child,ret);
        }        
        return ret;
        
    }
    private void getCellOnsets(EmbryoCell cell,HashMap<String,ExpressionOnset> map){
        ExpressionOnset onset = cell.getExpTimeSeries().getExprOnset();
        if (onset != null){
            map.put(cell.getName(),onset);
        }
           EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
           if (less != null) getCellOnsets(less,map);
           EmbryoCell great = (EmbryoCell)cell.getGreaterDaughter();
           if (great != null) getCellOnsets(great,map);        
    }
    // erase all the onsets in this embryo
    public void clearOnsets(){
        int n = root.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell child = (EmbryoCell)root.getChildAt(i);
            clearOnsets(child);
        }
    }
    // clear all the onsets in a cell and it's descendents
    public void clearOnsets(EmbryoCell cell){
           CellDataTimeSeries cdts = cell.getExpTimeSeries();
           cdts.setExprOnset(null,false); 
           EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
           if (less != null) clearOnsets(less);
           EmbryoCell great = (EmbryoCell)cell.getGreaterDaughter();
           if (great != null) clearOnsets(great);
    }
    // set all the onsets from the database for this embryo
    public final void setExpressionOnsets(HashMap<String,ExpressionOnset> map){
        clearOnsets();
        
        try {
            
            for (ExpressionOnset onset : map.values()){
                int n = root.getChildCount();
                for (int i=0 ; i<n ; ++i){
                    EmbryoCell child = (EmbryoCell)root.getChildAt(i);
                    if (setOnset(child,onset)){
                        break;
                    }
                }                
            }
        } catch (Exception exc){
            exc.printStackTrace();
        }        
    } 
    // set the onset for a cell in a subtree
    // return true if onset got set in the given subtree
    private boolean setOnset(EmbryoCell root,ExpressionOnset expOnset) throws Exception{
        EmbryoCell cell = root.getDescendent(expOnset.getCell());
        if (cell != null){
            CellDataTimeSeries cdts = cell.getExpTimeSeries();
            cdts.setExprOnset(expOnset,false);// don't mark this onset as changed, it is just being loaded from the database
            return true;
        }
        

        return false;
    }  
    public void reportOnsetChanges(PrintStream stream){
        for (EmbryoCell rt : this.roots){
            this.reportOnsetChanges(stream, rt);
        }
    }
    public void reportOnsetChanges(PrintStream stream,EmbryoCell cell){

        if (cell.getExpTimeSeries().getChanged()){
            ExpressionOnset onset = cell.getExpTimeSeries().getExprOnset();
            if (onset == null){
                stream.printf("%s : %s removed\n",this.seriesNuclei.seriesID, cell.getName());
            }else {
                stream.printf("%s : %s,%f", this.seriesNuclei.seriesID,cell.getName(),onset.getSulston());
            }

        }
        EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
        if (less != null) this.reportOnsetChanges(stream, less);

        EmbryoCell great = (EmbryoCell)cell.getGreaterDaughter();
        if (great != null) this.reportOnsetChanges(stream, great);        
    }
    public void saveOnsetChanges()throws Exception {
        for (EmbryoCell rt : this.roots){
            this.saveOnsetChanges(rt);
        }
    }    
    public void saveOnsetChanges(EmbryoCell cell) throws Exception {

        if (cell.getExpTimeSeries().getChanged()){
            ExpressionOnset onset = cell.getExpTimeSeries().getExprOnset();
            if (onset == null){
                String sql = String.format("delete from Onsets where Series=\'%s\' and Cell=\'%s\'",this.seriesNuclei.seriesID, cell.getName());
                db.execute(sql);
            }else {
                cell.getExpTimeSeries().getExprOnset().saveToDB(db);
            }

        }
        EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
        if (less != null) this.saveOnsetChanges(less);

        EmbryoCell great = (EmbryoCell)cell.getGreaterDaughter();
        if (great != null) this.saveOnsetChanges(great);        
    }    
    MySql db;
}