/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Set;
import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
public class TimePointFile {
    public TimePointFile(Element fileEle,Set<String> transcripts){
        this.fileEle = fileEle;
        this.transcripts = transcripts;
        fileName = fileEle.getAttributeValue("name");
        this.column = Integer.valueOf(fileEle.getAttributeValue("column"));
        this.time = Integer.valueOf(fileEle.getAttributeValue("time"));
        
    }
    // read the data into the map at the given array position
    public void readData(HashMap<String,double[]> dataMap,int pos,int dataSize)throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = reader.readLine();
        while(line != null){
            String[] tokens = line.split(",");
            if (transcripts.contains(tokens[0])){
                double[] data = dataMap.get(tokens[0]);
                if (data == null){
                    data = new double[dataSize];
                    dataMap.put(tokens[0], data);
                }
                data[pos] = Double.valueOf(tokens[column]);
            }
            line = reader.readLine();
        }
        
    }
    public int getSampleTime(){
        return time;
    }
    Element fileEle;
    Set<String> transcripts ; 
    String fileName;
    int column;  //column in data file to use
    int time;  // sample time
}
