/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.math3.stat.StatUtils;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class RNASeq {
    public RNASeq(String exp,String gene)throws Exception {
        if (state == null){
            state = MySql.getMySql().getStatement("Select * from RnaSeq where Experiment = ? and Gene = ?");
        }
        state.setString(1, exp);
        state.setString(2, gene);
        state.execute();
        ResultSet rs = state.getResultSet();
        while(rs.next()){
            data.put((Integer)rs.getObject("ExpTime"),(Double)rs.getObject("Expression"));
        }
        // compute mean and sd
        double[] x = new double[data.size()];
        int i=0;
        for (Entry entry : data.entrySet()){
            x[i] = (Double)entry.getValue();
            ++i;
        }
        mean = StatUtils.mean(x);
        sd = Math.sqrt(StatUtils.variance(x));
    }
    public Set<Integer> getSampleTimes(){
        return data.keySet();
    }
    public double getExpression(Integer sampleTime){
        return data.get(sampleTime);
    }
    public double getMean(){
        return mean;
    }
    public double getSD(){
        return sd;
    }
    double mean;
    double sd;
    static PreparedStatement state;
    TreeMap<Integer,Double> data = new TreeMap<>();;
}
