/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math3.stat.StatUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.rhwlab.db.MySql;


/**
 *
 * @author gevirl
 */
public class DataSource {
    // args[0] - directory with data files
    // args[>0] - data file names
    public DataSource(String[] args)throws Exception {
        expSources = new HashMap<>();
        String dir = args[0];
        for (int i=1 ; i<args.length ; ++i){
            ExperimentDataSource expSource = new ExperimentDataSource(new File(dir,args[i]));
            this.expSources.put(args[i], expSource);
        }
    }
    public DataSource(File dir,String[] exps)throws Exception {
        expSources = new HashMap<>();
        for (int i=0 ; i<exps.length ; ++i){
            ExperimentDataSource expSource = new ExperimentDataSource(new File(dir,exps[i]));
            this.expSources.put(exps[i], expSource);
        }
    }    
    public double[] getZScoreData(String filename,String feature)throws Exception {
        double[] d = this.getExpFeatureData(filename, feature);
        double mu = StatUtils.mean(d);
        double sig = Math.sqrt(StatUtils.variance(d, mu));
        for (int i=0 ; i<d.length ; ++i){
            d[i] = (d[i]-mu)/sig;
        }
        return d;
    }    
    public DataSource(){
        
    }
    public DataSource(String xmlFile)throws Exception {
        this(xmlFile,null);
    }
    // construct the dta source from the xml configuration 
    public DataSource(String xmlFile,String globalDataFile)throws Exception {
        parseXML(xmlFile,globalDataFile);
    }  
    public DataSource(Element root)throws Exception {
        fromElement(root,null);
    }
    private void parseXML(String xmlFile,String globalDataFile)throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(new File(xmlFile)); 
        
        Element root = doc.getRootElement();
        fromElement(root,globalDataFile);        
    }
    public double[] getNormalizedFeatureData(String experiment,String feature)throws Exception{
        return getNormalizedFeatureData(experiment,feature,100.0,10.0);
    }
    public double[] getNormalizedFeatureData(String experiment,String feature,double mean,double sd)throws Exception{
        return expSources.get(experiment).getNormalizedFeatureData(feature, mean, sd);
    }
    private void fromElement(Element root,String globalDataFile)throws Exception {
        String rootFile = root.getAttributeValue("file");
        String pcaStr = root.getAttributeValue("PCA");
        if (pcaStr !=null){
            pca = new Double(pcaStr);
        }
        if (rootFile != null){
            // override the supplied globalDataFile
            globalDataFile = rootFile;
        }
        
        featureList = null;
        
        Element featuresEle = root.getChild("Features");
        if (featuresEle != null){
            featureSource = new FeaturesDataSource(featuresEle);
            featureList = featureSource.getFeatures();
        }
        
        Element transEle = root.getChild("Transcripts");
        if (transEle != null){
            File transFile = new File(transEle.getAttributeValue("file"));
            BufferedReader reader = new BufferedReader(new FileReader(transFile));
            String trans = reader.readLine();
            while(trans != null){
                String[] tokens = trans.split(",");
                if (tokens.length>=1){
                    geneNames.put(tokens[0], null);
                }if (tokens.length >= 2){
                    geneNames.put(tokens[0], tokens[1]);  // gene names indexed by transcript
                }else if(tokens.length >= 3){
                    
                    geneTypes.put(tokens[0], tokens[2]);// gene type indexed by transcript
                    types.add(tokens[2]);
                }
                trans = reader.readLine();
            }
            reader.close();
            featureList = geneNames.keySet();
        }
        Element genesEle = root.getChild("Genes");
        if (genesEle != null){
            File genesFile = new File(genesEle.getAttributeValue("file"));
            BufferedReader reader = new BufferedReader(new FileReader(genesFile));
            String gene = reader.readLine();
            while(gene != null){
                geneNames.put(gene, null);
                gene = reader.readLine();
            }
            reader.close();
            featureList = geneNames.keySet();
        }        
        
        List<Element> kdes = root.getChildren("KDE");
        for (Element kdeEle : kdes){
        
            if (kdeSource==null){
                kdeSource = new KDEDataSource(kdeEle);
            }
            else {
                kdeSource.addFeatures(kdeEle);
            }
        }
        List<Element> exps = root.getChildren("Experiment");
        expSources = new HashMap<String,ExperimentDataSource>();
        for (Element expEle : exps){
            ExperimentDataSource source =  new ExperimentDataSource(expEle,featureList,globalDataFile);
            expSources.put(source.getName(),source);
        }        
    }

    public double[] getKDEData(String transcript,String type){
        if (kdeSource==null) return null;
        return kdeSource.getData(transcript, type);
    }
    // get the expression data for the given experiment and transcript
    public double[] getExpData(String experiment,String transcript)throws Exception {
        return expSources.get(experiment).getData(transcript);
    }
    public double[] getExpFeatureData(String experiment,String feature)throws Exception {
        ExperimentDataSource expDataSource = expSources.get(experiment);
        return expDataSource.getFeatureData(feature);

    }    
    public Set<String> getTranscriptList(){
        return geneNames.keySet();
    }
    public String getGeneName(String transcript){
        return geneNames.get(transcript);
    }
    public String[] getExperiments(){
        return expSources.keySet().toArray(new String[0]);
    }
    public double[] getKDETimes(String experiment){
        return kdeSource.getTimes(experiment);
    }
    public double[] getExperimentTimes(String experiment){
        return expSources.get(experiment).getTimes(); 
    }
    public double overallMean(String transcript) throws Exception {
        return StatUtils.mean(allData(transcript));
    }
    public double overallSD(String transcript,double mu) throws Exception {
        return Math.sqrt(StatUtils.variance(allData(transcript),mu));
    }  
    // make a vector of all the DCPM values from all the experiments and time points for a given transcript
    public double[] allData(String transcript) throws Exception {
        ArrayList<Double> temp = new ArrayList<Double>();
        for (String experiment : getExperiments()){
            double[] data = getExpData(experiment,transcript);
            for (double d : data){
                temp.add(new Double(d));
            }
        }
        double[] data = new double[temp.size()];
        for (int i=0 ; i<data.length;++i){
           data[i] = temp.get(i);
        }
        return data;
    } 
    // make a vector of all the DCPM values from all the experiments and time points for a given transcript
    public double[] allFeatureData(String feature) throws Exception {
        ArrayList<Double> temp = new ArrayList<Double>();
        for (String experiment : getExperiments()){
            double[] data = getExpFeatureData(experiment,feature);
            if (data == null){
                System.out.printf("Not found: %s\n", feature);
            }
            for (double d : data){
                temp.add(new Double(d));
            }
        }
        double[] data = new double[temp.size()];
        for (int i=0 ; i<data.length;++i){
           data[i] = temp.get(i);
        }
        return data;
    }     
    public ExperimentDataSource getExperimentSource(String exp){
        return expSources.get(exp);
    }
    public KDEDataSource getKDESource(){
        return kdeSource;
    }
    public String getTranscriptType(String trans){
        return geneTypes.get(trans);
    }
    public String[] getAllTranscriptTypes(){
        return types.toArray(new String[0]);
    }
    public void setColors(HashMap<String,Color> colors){
        this.colors = colors;
    }
    public HashMap<String,Color> getColors(){
        return this.colors;
    }
    // make a global set of all the features from all the experiments
    public Set<String> getFeatures()throws Exception {
        if (featureList == null){
            featureList = new TreeSet<>();
            Iterator<ExperimentDataSource> iter = expSources.values().iterator();
            while(iter.hasNext()){
                ExperimentDataSource ds = iter.next();
                Set<String> features = ds.getFeatures();
                featureList.addAll(features);
            }            
        }
        return featureList;
    }
    
    public Set<String> getFeatures(String startsWith) throws Exception {
        TreeSet<String> ret = new TreeSet<String>();
        String sql = String.format("Select distinct Feature from DCPM where Feature like \'%s",startsWith)+ "%\'";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            ret.add(rs.getString("Feature"));
        }
        return ret;        
    }
    /*
    // get the suslton times of the stages calculated for the given experiment
    public double[] getSulstonTimes(String exper){
        P_StartEnd P = new P_StartEnd(this,exper);
        
        return P.getSulstonTimes();
    }    
    public double getStartTime(String exper){
        P_StartEnd P = new P_StartEnd(this,exper);
        return P.getStartTime();
    }
    * */
    public void printUsableFeatures(PrintStream writer)throws Exception {
        Set<String> features = this.getFeatures();
        String[] experiments = this.getExperiments();

        for (String feature : features) {
            boolean featureUsable = true;
            ArrayList<Double> featureData = new ArrayList<>();
            for (String experiment : experiments) {
                boolean expUsable = false;
                ExperimentDataSource expDataSource = this.getExperimentSource(experiment);
                double[] expFeatureData = expDataSource.getFeatureData(feature);
                if (expFeatureData == null) {
                    featureUsable = false;
                    break;
                }
                for (double d : expFeatureData) {
                    featureData.add(new Double(d));
                    if (d > 0.0) {
                        expUsable = true;
                    }
                }
                if (!expUsable) {
                    featureUsable = false;
                    break;
                }
            }
            if (featureUsable) {
                writer.printf("%s",feature);
                for (Double d : featureData){
                    writer.printf(",%f", d);
                }
                writer.println();
            }
        }        
    }
    public void setXMLFile(String xml)throws Exception {
        this.xml = xml;
        this.parseXML(xml, null);
    }
    public void setFeatureListFile(String file)throws Exception{
        this.featureList = new TreeSet<>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String feature = reader.readLine();
        while(feature != null){
            featureList.add(feature);
            feature = reader.readLine();
        }
        reader.close();
    }
  
    static public void main(String[] args)throws Exception {
        DataSource ds = new DataSource(args[0]);
        ds.printUsableFeatures(System.out);
        int asrfh=0;
    }
    String xml=null;
    FeaturesDataSource featureSource;
    KDEDataSource kdeSource;
    HashMap<String,ExperimentDataSource> expSources;
 //   HashSet<String> transcripts = new HashSet<String>();
    HashMap<String,String> geneNames = new HashMap<String,String>();  // gene names indexed by transcript
    HashMap<String,String> geneTypes = new HashMap<String,String>();  // gene types indexed by transcript
    TreeSet<String> types = new TreeSet<String>();  // types are Factor,Kinase,Other etc
    HashMap<String,Color> colors;
    Set<String> featureList;
    Double pca=null;  // if not null - use prinicple components as features
}
