/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import org.apache.commons.math3.stat.StatUtils;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class Zscore implements Normalization  {

    @Override
    public DataSet normalize(DataSet in) {
        double[][] x = in.getAsDouble();
        normalize(x);
        // add the new columns to the df
        DataFrame df = in.getDataFrame();
        String[] colNames = in.getColumnNames();
        for (int i=0 ; i<colNames.length ; ++i){
            colNames[i] = "Zscore"+colNames[i];
        }
        
        int[] len1Cols = df.addColumns(x, colNames);  
        DataSet ds = new DataSet("Zscore"+in.toString(),df,len1Cols,in.getAttributes().toArray(new String[0]));
        for (String attr : in.getAttributes()){
            for (int i=0 ; i<in.getColumns().length ; ++i){
                String value = in.getAttribute(attr, i);
                ds.setAttribute(attr, i, value);
            }
        }
        return ds;        
    }
    
    public String toString(){
        return "Zscore";
    }

    @Override
    public void normalize(double[][] x) {
        for (int i=0 ; i<x.length ; ++i){
            x[i] = StatUtils.normalize(x[i]);
        }
    }



    
}
