/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class SumTo1 implements Normalization {

    @Override
    public void normalize(double[][] x) {
        for (int i = 0; i < x.length; ++i) {
            double s = 0.0;
            for (int c = 0; c < x[i].length; ++c) {
                s = s + x[i][c];
            }
            if (s != 0) {
                for (int c = 0; c < x[i].length; ++c) {
                    x[i][c] = x[i][c] / s;
                }
            }
        }
    }

    @Override
    public String toString() {
        return "SumTo1";
    }

    @Override
    public DataSet normalize(DataSet in) {
        double[][] x = in.getAsDouble();
        normalize(x);

        // add the new columns to the df
        DataFrame df = in.getDataFrame();
        String[] colNames = in.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = "Sum1" + colNames[i];
        }
        int[] max1Cols = df.addColumns(x, colNames);
        DataSet ds = new DataSet("Sum1" + in.toString(), df, max1Cols, in.getAttributes().toArray(new String[0]));
        for (String attr : in.getAttributes()) {
            for (int i = 0; i < in.getColumns().length; ++i) {
                String value = in.getAttribute(attr, i);
                ds.setAttribute(attr, i, value);
            }
        }
        // duplicate the colum attributes in the new dataset
        return ds;
    }

}
