/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
// transformation that performs only a normalization of the dataset
public class NormalizationOnly implements Transform {

    @Override
    public DataSet xform(DataSet in, Normalization norm) {
        double[][] x = in.getAsDouble();
        norm.normalize(x);
        // add the new columns to the df
        DataFrame df = in.getDataFrame();
        String[] colNames = in.getColumnNames();
        for (int i=0 ; i<colNames.length ; ++i){
            colNames[i] = norm.toString()+colNames[i];
        }
        
        int[] len1Cols = df.addColumns(x, colNames);  
        DataSet ds = new DataSet(norm.toString()+in.toString(),df,len1Cols,in.getAttributes().toArray(new String[0]));
        for (String attr : in.getAttributes()){
            for (int i=0 ; i<in.getColumns().length ; ++i){
                String value = in.getAttribute(attr, i);
                ds.setAttribute(attr, i, value);
            }
        }
        return ds;
    }
    public String toString(){
        return "Normalize";
    }
}
