/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class MDS implements Transform {

    @Override
    public DataSet xform(DataSet in,Normalization norm) {
        jsat.datatransform.visualization.MDS mds = new jsat.datatransform.visualization.MDS();
        jsat.DataSet jsatDS = mds.transform(in.toJsatDataSet());
        DataFrame df = in.getDataFrame();
        
        String[] heads = new String[2];
        heads[0] = "MDSX";
        heads[1] = "MDSY";
        int[] cols = df.addColumns(jsatDS, heads);
        
        String[] attrKeys = new String[1];
        attrKeys[0] = "Coord";
        DataSet ret = new DataSet(this.toString()+in.toString(),df,cols,attrKeys); 
        ret.setAttribute(attrKeys[0],0,"X");
        ret.setAttribute(attrKeys[0],1,"Y");    
        
        return ret;
    }
    
    public String toString(){
        return "MDS";
    }
    
}
