/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class LenTo1 implements Normalization {

    @Override
    public DataSet normalize(DataSet in) {
        double[][] x = normalizeLength(in.getAsDouble());

        // add the new columns to the df
        DataFrame df = in.getDataFrame();
        String[] colNames = in.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = "Len1" + colNames[i];
        }
        int[] len1Cols = df.addColumns(x, colNames);
        DataSet ds = new DataSet("Len1" + in.toString(), df, len1Cols, in.getAttributes().toArray(new String[0]));
        for (String attr : in.getAttributes()) {
            for (int i = 0; i < in.getColumns().length; ++i) {
                String value = in.getAttribute(attr, i);
                ds.setAttribute(attr, i, value);
            }
        }
        // duplicate the colum attributes in the new dataset
        return ds;
    }

    static public double[][] normalizeLength(double[][] x) {
        for (int r = 0; r < x.length; ++r) {
            double sumsqr = 0.0;
            for (int c = 0; c < x[r].length; ++c) {
                sumsqr = sumsqr + x[r][c] * x[r][c];
            }
            sumsqr = Math.sqrt(sumsqr);
            if (sumsqr > 0.0) {
                for (int c = 0; c < x[r].length; ++c) {
                    x[r][c] = x[r][c] / sumsqr;
                }
            }
        }
        return x;
    }

    @Override
    public String toString() {
        return "Len=1";
    }

    @Override
    public void normalize(double[][] x) {
        normalizeLength(x);
    }
}
