/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class AverageSamples implements Transform {

    @Override
    public DataSet xform(DataSet in,Normalization norm) {
        String[] choices = in.getAttributes().toArray(new String[0]);
        Object sel = JOptionPane.showInputDialog(null,"Choose the samples to average", "Sample Averaging", JOptionPane.QUESTION_MESSAGE,null ,choices, choices[0]);
        if (sel != null){
            String choice = (String)sel;
            DataFrame df = in.getDataFrame();
            
            // determine the columns to average
            TreeMap<String,List<Integer>> colsToAvg = new TreeMap<>();
            int[] cols = in.getColumns();
            for (int c=0 ; c<cols.length ; ++c){
                String key = formKey(in,c,choices,choice);
                List<Integer> colList =  colsToAvg.get(key);
                if (colList == null){
                    colList = new ArrayList<>();
                    colsToAvg.put(key,colList);
                }
                colList.add(cols[c]);
            }
            
            // form the new columns
            int[] addedCols = new int[colsToAvg.keySet().size()];
            int n=0;
            for (String key : colsToAvg.keySet()){
                List<Integer> toAvg = colsToAvg.get(key);
                int[] columnsToAvg = new int[toAvg.size()];
                for (int i=0 ; i<toAvg.size() ; ++i){
                    columnsToAvg[i] = toAvg.get(i);
                }
                double[][] x = df.getAsDouble(columnsToAvg);
                double avg[] = new double[x.length];
                for (int i=0 ; i<avg.length ; ++i){
                    avg[i] = x[i][0];
                }
                for (int c=1 ; c<columnsToAvg.length ; ++c){
                    for (int i=0 ; i<avg.length ; ++i){
                        avg[i] = avg[i] + x[i][c];
                    }                    
                }
                for (int i=0 ; i<avg.length ; ++i){
                    avg[i] = avg[i]/columnsToAvg.length;
                }                
                addedCols[n] = df.addColumn(avg, key);
                ++n;
            }
            String title = String.format("Avg%s%s",choice,in.toString());
            String[] attrs = new String[choices.length-1];
            int j=0;
            for (int i=0 ; i<choices.length ; ++i){
                if (!choices[i].equals(choice)){
                    attrs[j] = choices[i];
                    ++j;
                }
            }
            DataSet ret = new DataSet(title,in.getDataFrame(),addedCols,attrs);
            int dsCol =0;
            for (String key : colsToAvg.keySet()){
                String[] keyTokens = key.split(",");
                for (int a=0 ; a<attrs.length ; ++a){
                    ret.setAttribute(attrs[a], dsCol,keyTokens[a] );
 int iuashdfuis=0;
                }
                ++dsCol;
            }
            return ret;
        }
        return null;
    }
    private String formKey(DataSet ds,int col,String[] attrs,String choice){
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String attr : attrs){
            if (!attr.equals(choice)){
                if (!first){
                    builder.append(",");
                }                
                builder.append(ds.getAttribute(attr, col));
                first = false;
            }
        }
        return builder.toString();
    }
    @Override
    public String toString(){
        return "AvgSamples";
    }
}
