/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.measure;

import org.rhwlab.LMS.dataframe.*;

/**
 *
 * @author gevirl
 */
public class JensenShannonMetric implements org.apache.commons.math3.ml.distance.DistanceMeasure {

    @Override
    public double compute(double[] a, double[] b) {
        
        double d = Util.jensenShannonDivergence(a, b);
        return Math.sqrt(d);
/*        
    //    double[] an = normalize(a);
     //   double[] bn = normalize(b);
        double[] avg = new double[a.length];
        
        for (int i=0 ; i<avg.length ; ++i){
            avg[i] = .5*(a[i] + b[i]);
        }
        double A = entropy(avg);
        double B = .5*(entropy(a)+entropy(b));
        if ( A < B){
            System.err.println("JS metric error");
            System.exit(0);
        }
//        return  Math.sqrt(A - B);
        return (A - B);
*/
    }
    
    static double entropy(double[] p){
        double e=0.0;
        for (int i=0 ; i<p.length ; ++i){
            if (p[i] > 0.0){
                e = e - p[i]*Math.log(p[i]);
            }
        }
        return e;
    }
    static double[] normalize(double[] x){
        double[] r = new double[x.length];
        
        double sum = 0.0;
        for (int i= 0 ; i<x.length ; ++i){
            sum = sum + x[i];
        }
        for (int i= 0 ; i<x.length ; ++i){
            r[i] = x[i]/sum;
        }  
        return r;
    }
    
    @Override
    public String toString(){
        return "JSMetric";
    }
    
}
