/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.algorithm;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.jdom2.Element;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.investigator.Clustering;
import org.rhwlab.LMS.dataframe.investigator.measure.NamedEuclidean;

/**
 *
 * @author gevirl
 */
public class Silhouette implements Runnable {
    DataSet ds;
    DistanceMeasure meas;
    int[][] clusters;
    List<double[]> results;
    ActionListener toNotify;
    double thresh;
    double avg;
    
    public Silhouette(DataSet ds,Clustering cl,ActionListener toNotify){
        this.ds = ds;
        clusters = cl.getClusters();
        meas = new NamedEuclidean();
        this.toNotify = toNotify;
        thresh = cl.getProbabilityThreshold();
    }

    public Silhouette(Element ele){
        thresh = Double.valueOf(ele.getAttributeValue("threshold"));
        avg = Double.valueOf(ele.getAttributeValue("average"));
        results = new ArrayList<>();
        for (Element resultEle : ele.getChildren("Result")){
            String text = resultEle.getTextNormalize();
            double[] v = new double[0];
            if (text.length() > 0) {
                String[] tokens =resultEle.getTextNormalize().split(",");
                v = new double[tokens.length];
                for (int i=0 ; i<tokens.length ; ++i){
                    v[i] = Double.valueOf(tokens[i]);
                }
            }
            results.add(v);
        }
    }
    public Element toXML(){
        Element ret = new Element("Silhouette");
        ret.setAttribute("threshold", Double.toString(thresh));
        ret.setAttribute("average", Double.toString(avg));
        
        for (double[] result : results){
            StringBuilder builder = new StringBuilder();
            Element rEle = new Element("Result");
            if (result.length > 0){
                builder.append(String.format("%.4f",result[0]));
                for (int i=1; i <result.length ; ++i){
                    builder.append(",");
                    builder.append(String.format("%.4f",result[i]));
                }
                rEle.addContent(builder.toString());
            }
            ret.addContent(rEle);
        }
        return ret;
    }
    @Override
    public void run() {
        ExecutorService pool = Executors.newFixedThreadPool(8);
        ArrayList<Callable<double[]>> tasks = new ArrayList<>();
        for (int c=0 ; c<clusters.length-1 ; ++c){
            ClusterSilhouette silh =  new ClusterSilhouette(ds,clusters,meas,c);
            tasks.add(silh);
        }
        try {
            List<Future<double[]>> futureList = pool.invokeAll(tasks);
            results = new ArrayList<>();
            for (Future<double[]> future : futureList){
                double[] v = future.get();
                if (v == null){
                    v = new double[0];
                }
                results.add(v);
            }
            avg = 0.0;
            int count =0;
            for (int c=0 ; c<clusters.length-1 ; ++c){
                for (double s : getSilhouette(c)){
                    avg = avg + s;
                    ++count;
                }
            }
            avg = avg/count;
            toNotify.actionPerformed(null);
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }
    
    public int getClusterCount(){
        return clusters.length - 1; // not including the unclustered group;
    }
    
    public double[] getSilhouette(int clust) throws Exception {
        if (isFinished()){
            return results.get(clust);
        }
        return null;

    }
    public double getAverage(){
        return avg;
    }
    public String toString(){
        return String.format("Threshold=%.4f ; Average=%.4f", thresh,avg);
    }
    public boolean isFinished(){
        return results !=null;
    }
}
