/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.algorithm;

import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.ParallelGroup;
import javax.swing.GroupLayout.SequentialGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.rhwlab.LMS.dataframe.LabeledClusterable;
import org.rhwlab.LMS.dataframe.investigator.Clustering;

/**
 *
 * @author gevirl
 */
public class KMeans implements ClusterAlgorithm  {
    JPanel parameterPanel = new JPanel();
    JTextField nClustersField = new JTextField("      ");
    int iterations = 1000;
    
    public KMeans(){
        
        GroupLayout layout = new GroupLayout(parameterPanel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        parameterPanel.setLayout(layout);
        
        JLabel label = new JLabel("# of Clusters");
        
        SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addComponent(label).addComponent(nClustersField);
        layout.setHorizontalGroup(hGroup);
        
        ParallelGroup vGroup = layout.createParallelGroup();
        vGroup.addComponent(label).addComponent(nClustersField);
        layout.setVerticalGroup(vGroup);
    }
    
    @Override
    public String toString(){
        return "Kmeans";
    }
    @Override
    public JPanel getParameterPanel() {
        return parameterPanel;
    }

    @Override
    public Clustering cluster(String dsName,double[][] x,DistanceMeasure measure,String norm) {
        
        ArrayList<Clusterable> collect = new ArrayList<>();
        int i=0;
        for (double[] row : x){
            collect.add(new LabeledClusterable(row,i));
            ++i;
        }          
        int nClusters = Integer.valueOf(this.nClustersField.getText().trim());
        KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(nClusters,iterations,measure);
        List<CentroidCluster<Clusterable>> list = clusterer.cluster(collect); 
        
        int[] index = new int[x.length];
        int cl=0;
        for (Cluster cluster : list){
            for (Object obj : cluster.getPoints()){
                LabeledClusterable clusterable = (LabeledClusterable)obj;
                index[clusterable.getLabel()] = cl;
            }
            ++cl;
        }    
        String s = String.format("Kmeans ; %s ; %s ; %s ; %s",dsName,norm,measure.toString(),nClustersField.getText().trim());
        Clustering ret = new Clustering(s,index);
        return ret;
    }
    
}
