/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.algorithm;

import java.util.concurrent.Callable;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.investigator.Clustering;

/**
 *
 * @author gevirl
 */
public class ClusterSilhouette implements Callable<double[]>  {
    DataSet ds;
    int[][] clusters;
    DistanceMeasure meas;
    int[] rows;
    int clust;
    
    public ClusterSilhouette(DataSet ds,int[][] clusters,DistanceMeasure m,int cluster){
        this.ds = ds;
        this.clusters = clusters;
        rows = clusters[cluster];
        meas = m;
        clust = cluster;
    }
    @Override
    public double[] call() {
        System.out.printf("Silhouette starting for %d\n", clust);
        double[] silh = new double[rows.length];
        for (int i=0 ; i<silh.length ; ++i){
            double a = avgDist(rows[i],rows);
            int cMin = -1;
            double b = Double.MAX_VALUE;
            for (int c =0 ; c<clusters.length-1 ; ++c){  // do not use the last unclustered group
                if (c != clust){
                    double v = avgDist(rows[i],clusters[c]);
                    if (v < b){
                        b = v;
                        cMin = c+1;
                    }
                }
            }
            silh[i] = s(a,b);
//            System.out.printf("cluster=%d row=%d\n",clust,rows[i]);
        }
        System.out.printf("Silhouette finished for %d\n", clust);
        return silh;
    }
    // average distance from a data item to all other items in a cluster
    private double avgDist(int i,int[] rows){
        boolean found = false;
        double sum = 0;
        double[] x = ds.getRow(i);
        for (int r : rows){
            sum = sum + meas.compute(x, ds.getRow(r));
            if (r == i){
                found = true;
            }
        }
        if (found){
            return sum/(rows.length-1);
        } else {
            return sum/(rows.length);
        }
    }
    private double s(double a,double b){
        if (a < b){
            return 1.0 - a/b;
        }
        else if (a > b){
            return b/a - 1.0;
        }else {
            return 0.0;
        }
    }    
}
