/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.util.Arrays;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.investigator.algorithm.Silhouette;

/**
 *
 * @author gevirl
 */
public class SilhouettePanel extends ChartPanel {
    public SilhouettePanel(Silhouette silh,Clustering clustering,int cl){
        super(formChart(silh,clustering,cl));
    }
    static private JFreeChart formChart(Silhouette silh,Clustering clustering,int cl){
        try {
            XYSeriesCollection collect = new XYSeriesCollection();
            double x = 0.0;
                XYSeries series = new XYSeries(String.format("Cluster%d",cl+1));
                collect.addSeries(series);
                double[] s = silh.getSilhouette(cl);
                Arrays.sort(s);
                for (int i=0 ; i<s.length ; ++i){
                    series.add(x, s[i]);
                    x = x + 1;
                }
            NumberAxis xAxis = new NumberAxis("Genes");
            NumberAxis yAxis = new NumberAxis("Silhouette");
            XYItemRenderer renderer = new XYBarRenderer();
            XYPlot plot = new XYPlot(collect,xAxis,yAxis,renderer);

            return new JFreeChart(clustering.title,JFreeChart.DEFAULT_TITLE_FONT,plot,true);
        
        }
        catch (Exception exc){
            
        }
        return null;
    }
}
