/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

/**
 *
 * @author gevirl
 */
public class SavableImageFrame extends JFrame {

    JFileChooser chooser = new JFileChooser();
    
    public SavableImageFrame() {
        super();
        
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            menuBar = new JMenuBar();
            this.setJMenuBar(menuBar);
        }
        
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        
        JMenu saveAs = new JMenu("SaveAs");
        fileMenu.add(saveAs);
        
        for (String format : ImageIO.getWriterMIMETypes()) {
            JMenuItem formatItem = new JMenuItem(format);
            formatItem.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (chooser.showSaveDialog(SavableImageFrame.this) == JFileChooser.APPROVE_OPTION) {
                        try {
                            FileImageOutputStream stream = new FileImageOutputStream(chooser.getSelectedFile());
                            JMenuItem item = (JMenuItem) e.getSource();
                            ImageWriter writer = ImageIO.getImageWritersByMIMEType(item.getText()).next();
                            writer.setOutput(stream);
                            
                            Component comp = SavableImageFrame.this.getContentPane();
                            Dimension size = comp.getSize();
                            BufferedImage theImage = new BufferedImage(size.width,size.height,BufferedImage.TYPE_INT_RGB);
                            Graphics2D g2 = theImage.createGraphics();
                            comp.paint(g2);
                            
                            writer.write(theImage);
                            stream.close();
                        } catch (Exception exc) {
                            exc.printStackTrace();
                        }
                        
                        int usdfuhd = 0;
                    }
                }
            });
            saveAs.add(formatItem);
        }
        
        int uiashdfus = 0;
    }
    
    static public void saveToFile(Component comp,File file,String mime)throws Exception {
        FileImageOutputStream stream = new FileImageOutputStream(file);
        ImageWriter writer = ImageIO.getImageWritersByMIMEType(mime).next();
        writer.setOutput(stream);

        Dimension size = comp.getSize();
        comp.setVisible(true);
        BufferedImage theImage = new BufferedImage(size.width,size.height,BufferedImage.TYPE_INT_RGB);
        Graphics2D g2 = theImage.createGraphics();
        comp.paint(g2);

        writer.write(theImage);
        stream.close();
}
}
