/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.ParallelGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 *
 * @author gevirl
 */
public class ParameterPanel extends JPanel {
    JLabel[] labels;
    JTextField[] fields;
    
    public ParameterPanel(String[] params){
        
        GroupLayout layout = new GroupLayout(this);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        this.setLayout(layout);
        
        labels = new JLabel[params.length];
        fields = new JTextField[params.length];
        for (int i=0 ; i<labels.length ; ++i){
            labels[i] = new JLabel(params[i]);
            fields[i] = new JTextField("      ");
        }
        
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        ParallelGroup hLabelGroup = layout.createParallelGroup();
        ParallelGroup hFieldGroup = layout.createParallelGroup();
        for (int i=0 ; i<params.length ; ++i){
            hLabelGroup.addComponent(labels[i]);
            hFieldGroup.addComponent(fields[i]);
        }
        hGroup.addGroup(hLabelGroup);
        hGroup.addGroup(hFieldGroup);
        layout.setHorizontalGroup(hGroup);
        
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        for (int i=0 ; i<params.length ; ++i){
            ParallelGroup row = layout.createParallelGroup();
            row.addComponent(labels[i]);
            row.addComponent(fields[i]);
            vGroup.addGroup(row);
        }
        layout.setVerticalGroup(vGroup);         
    }
    public TreeMap<String,String> getValues(){
        TreeMap<String,String> ret = new TreeMap<>();
        for (int i=0 ; i<labels.length ; ++i){
            ret.put(labels[i].getText(),fields[i].getText().trim());
        }
        return ret;
    }
}
