/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class DataSetBox extends Observable implements Observer {

    JComboBox box = new JComboBox();

    public DataSetBox() {
        box.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (box.getSelectedItem() != null) {
                    DataSetBox.this.setChanged();
                    DataSetBox.this.notifyObservers(box.getSelectedItem());
                }
            }
        });
    }

    public JComboBox getBox() {
        int iusagdfuigsdf=0;
        return box;
    }

    @Override
    public void update(Observable o, Object arg) {
        DataFrameBox dfBox = (DataFrameBox) o;
        update(dfBox);
    }

    public void update(DataFrameBox dfBox) {

        DataFrame df = dfBox.getSelected();

        if (df != null) {
            DefaultComboBoxModel m = new DefaultComboBoxModel();
            List<DataSet> dsList = dfBox.getInvestigation().getDataSets(df);
            if (dsList != null) {
                for (DataSet ds : dsList) {
                    m.addElement(ds);
                }
                box.setModel(m);
                box.setSelectedIndex(0);
                this.setChanged();
                this.notifyObservers(box.getSelectedItem());
            }
        }
    }

    public DataSet[] getDataSets() {
        int n = box.getItemCount();
        DataSet[] sets = new DataSet[n];
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = (DataSet) box.getItemAt(i);
        }
        return sets;
    }
}
