/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedRangeCategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class ClusterBoxAndWhiskerPanel extends ChartPanel {
    
    public ClusterBoxAndWhiskerPanel(String title,DataSet ds,int[] rows,String timeAttr,String seriesAttr) {
        super(buildChart(title,ds,rows,timeAttr,seriesAttr));
    }
    static JFreeChart buildChart(String title,DataSet ds,int[] rows,String timeAttr,String seriesAttr){
        TreeMap<String,TreeMap<String,List<Double>>> dataLists = new TreeMap<>();
            
        for (int r=0 ; r<rows.length ; ++r){
            int row = rows[r];
            double[] rowData = ds.getRow(row);
            for (int c=0 ; c<ds.getColumns().length ; ++c){
                String timeLabel = ds.getAttribute(timeAttr, c);
                String seriesLabel = ds.getAttribute(seriesAttr, c);                
                TreeMap<String,List<Double>> seriesLists = dataLists.get(seriesLabel);
                if (seriesLists == null){
                    seriesLists = new TreeMap<>();
                    dataLists.put(seriesLabel, seriesLists);
                }
                List<Double> timeList = seriesLists.get(timeLabel);
                if (timeList == null){
                    timeList = new ArrayList<>();
                    seriesLists.put(timeLabel,timeList);
                }
                timeList.add(rowData[c]);
            }
        }
        
        TreeMap<String,DefaultBoxAndWhiskerCategoryDataset> bwDatasets = new TreeMap<>();
        TreeMap<String,DefaultCategoryDataset> lineDatasets = new TreeMap<>();
        
        for (String series : dataLists.keySet()){
            DefaultBoxAndWhiskerCategoryDataset bwDataset = new DefaultBoxAndWhiskerCategoryDataset();
            DefaultCategoryDataset lineDataset = new DefaultCategoryDataset();
            TreeMap<String,List<Double>> seriesList = dataLists.get(series);
            for (String time : seriesList.keySet()){
                bwDataset.add(seriesList.get(time), time, "T0");
                Number mean = bwDataset.getMeanValue(time, "T0");
                lineDataset.addValue(mean,"T0",time);
            }
            bwDatasets.put(series,bwDataset);
            lineDatasets.put(series,lineDataset);
        }
        
        CombinedRangeCategoryPlot combplot = new CombinedRangeCategoryPlot();
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        renderer2.setBasePaint(Color.black);
        
        for (String series : bwDatasets.keySet()){
        
            CategoryAxis categoryAxis = new CategoryAxis(series);
            NumberAxis valueAxis = new NumberAxis("Expression");
            valueAxis.setAutoRangeIncludesZero(false);

            
            renderer.setBaseToolTipGenerator(new BoxAndWhiskerToolTipGenerator());

            CategoryPlot plot = new CategoryPlot(bwDatasets.get(series), categoryAxis, valueAxis,
                    renderer);

            
            plot.setDataset(1, lineDatasets.get(series));
            plot.setRenderer(1, renderer2);
    //        plot.mapDatasetToRangeAxis(1, 1);

    //        renderer2.setUseSeriesOffset(true);
            renderer2.setBaseLinesVisible(true);
            renderer2.setSeriesLinesVisible(0,true);
            renderer2.setSeriesLinesVisible(1,true);  
            renderer2.setSeriesPaint(0, Color.BLACK);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            combplot.add(plot);
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT,
                combplot, false);        
/*        
        final DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        DefaultCategoryDataset lineDS  =new DefaultCategoryDataset();
        TreeMap<String,DefaultCategoryDataset> meanDataSets = new TreeMap<>(); // indexed by series
        for (int c=0 ; c<ds.getColumns().length ; ++c){
            String rowLabel = ds.getAttribute(rowAttr, c);
            String colLabel = ds.getAttribute(colAttr, c);
            dataset.add(list.get(c), rowLabel, colLabel);
            Number mean = dataset.getMeanValue(rowLabel, colLabel);
            
            DefaultCategoryDataset meanDS = meanDataSets.get(colLabel);
            if (meanDS == null){
                meanDS = new DefaultCategoryDataset();
                meanDataSets.put(colLabel, meanDS);
            }
            lineDS.addValue(mean.doubleValue(), colLabel,rowLabel);
            System.out.println(mean.doubleValue());
        }
        
        JFreeChart chart = ChartFactory.createBoxAndWhiskerChart(ds.toString(), "Tissue", "Expression", dataset, true);
 //       chart = ChartFactory.createLineChart("title", "x", "y", meanDataSets.firstEntry().getValue(), PlotOrientation.VERTICAL, true,false,false);
        
        CategoryPlot plot = (CategoryPlot) chart.getPlot();
        LineAndShapeRenderer r = new LineAndShapeRenderer();
        r.setUseSeriesOffset(true);
        r.setBaseLinesVisible(true);
        r.setSeriesLinesVisible(0,true);
        NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        
            plot.setDataset(1, lineDS);
            plot.setRenderer(1, r);
/*            
        int i=1;
        for (DefaultCategoryDataset meands : meanDataSets.values()){
           
            plot.setDataset(i, meands);
            plot.setRenderer(i, r);
            plot.mapDatasetToRangeAxis(i, 0);
            r.setSeriesLinesVisible(i, true);
            ++i;
        }
*/
        return chart;
         
    }
}
