/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.ColorBrewer;

/**
 *
 * @author gevirl
 */
public class ListDisplayPanel extends JPanel implements ChangeListener {
    JList jList ;
    JLabel count = new JLabel("Count:");
    DataFrame df;
    String geneCol;
    JFrame plotframe;
    Plot2DPanel plot;
    int [] dataCols;
    ChartPanel chartPanel;
    
    public ListDisplayPanel(String[] values,DataFrame df,String geneCol,int[] columns){
        this.df = df;
        this.geneCol = geneCol;
        this.dataCols = columns;
        
        this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        
        DefaultListModel model = new DefaultListModel();
        for (String value : values){
            model.addElement(value);
        }        
        jList = new JList(model);
        jList.addListSelectionListener(new ListSelectionListener(){
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()){
                    displayGeneFreeChart((String)jList.getSelectedValue());
                }
            }
        });
        JScrollPane scroll = new JScrollPane(jList);
        this.add(scroll);
        this.add(count);
        
        plotframe = new JFrame();
        plotframe.getContentPane().setLayout(new BorderLayout());
        plot = new Plot2DPanel();
        
        
//        plotframe.add(plot,BorderLayout.CENTER);
        
        plot.addLegend("SOUTH");
        
        
        
        
    }
    private void displayGeneFreeChart(String gene){
        int n = dataCols.length/5 ;
        List<String> heads = df.getHeaders();
        Integer row = df.find(geneCol,gene);
        
        if (row != null){
            ArrayList<String> rowData = df.getRow(row);
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int offset = 0;
            for (int i=0 ; i<n ; ++i){
                for( int time=0 ; time<5 ; ++time){
                    int index = offset + time;
                    String name = org.rhwlab.LMS.dataframe.FACSSamples.parseName(heads.get(dataCols[index]));
                    String tissue = name.substring(0,name.indexOf("T"));
                    double v = Double.valueOf(rowData.get(dataCols[index]));
                    dataset.addValue(v,String.format("T%d",time),tissue);
                }
                offset = offset + 5;
            }
            JFreeChart chart = ChartFactory.createStackedBarChart
                        (gene,"Series", "TPM", dataset, PlotOrientation.VERTICAL,false,true,true);        
            chartPanel = new ChartPanel(chart);
            
            plotframe.getContentPane().removeAll();
            plotframe.add(chartPanel,BorderLayout.CENTER);
            plotframe.setVisible(true);
            plotframe.pack();	
            plotframe.setSize(900,600);        
            plotframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);             
        }        
    }
    private void displayGene(String gene){
        int n = dataCols.length/5 ;
        ColorBrewer[] brewers = ColorBrewer.getDivergingColorPalettes(true);
        brewers = ColorBrewer.getQualitativeColorPalettes(true);
        Color[] colors = brewers[0].getColorPalette(n);
        
        
        List<String> heads = df.getHeaders();
        Integer row = df.find(geneCol,gene);
        if (row != null){
            plotframe.setTitle(gene);
            plot.plotCanvas.removeAllPlots();
            ArrayList<String> rowData = df.getRow(row);
            int offset = 0;
            for (int t=0 ; t<n; ++t){
                
                double[] y = new double[5];
                for (int s=0 ; s<=4 ; ++s){
                    y[s] = Double.valueOf(rowData.get(dataCols[offset+s]));
                }
                
                plot.addLinePlot(heads.get(dataCols[offset]),colors[t],y);
                offset = offset + 5;
         
            }
            
            plotframe.setVisible(true);
            plotframe.pack();	
            plotframe.setSize(900,600);        
            plotframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);   
        }
    }
    @Override
    public void stateChanged(ChangeEvent e) {
        String[] values = (String[])e.getSource();
        Arrays.sort(values, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareToIgnoreCase(s2);
            }
        });
        DefaultListModel model = new DefaultListModel();
        for (String value : values){
            model.addElement(value);
        }
        count.setText(String.format("Count:%d",model.getSize()));
        jList.setModel(model);
    }
    
}
