/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import org.apache.commons.math3.ml.distance.DistanceMeasure;

/**
 *
 * @author gevirl
 */
public class DistanceMatrixImpl implements DistanceMatrix {
    double[][] x;
    DistanceMeasure measure;
    Double min;
    Double max;
    double[][] m;
    
    public DistanceMatrixImpl(DataFrame df,int[] columns,DistanceMeasure measure){
        this(df.getAsDouble(columns),measure);
    }
    public DistanceMatrixImpl(double[][]x,DistanceMeasure measure){
        this.x = x;
        this.measure = measure;
        buildMatrix();
    }
    private void buildMatrix(){
        m = new double[size()-1][];
        for (int i=0 ; i < m.length ; ++i){
            m[i] = new double[size()-1-i];
            for (int j=0 ; j<m[i].length ;++j){
                m[i][j] = measure.compute(x[i],x[i+j+1]);
            }
        }
        
    }
    @Override
    public double getDistance(int i, int j) {
        if (i == j){
            return 0.0;
        }
        if (i < j )
            return m[i][j-i-1];
        else 
            return m[j][i-j-1];
    }

    @Override
    public double getMin() {
        if (min == null)
            findMinMax();
        return min;
    }

    @Override
    public double getMax() {
        if (max == null) 
            findMinMax();
        return max;
    }

    private void findMinMax(){
        double n = Double.MAX_VALUE;
        double x = Double.MIN_VALUE;
        for (int i=0 ; i < size()-1 ; ++i){
            for (int j=i+1 ; j<size() ;++j){
                double v = getDistance(i,j);
                if (v < n){
                    n = v;
                }
                if (v > x){
                    x = v;
                }
            }
        }
        this.min = n;
        this.max = x;
    }
    @Override
    public int size() {
        return x.length;
    }
    
}
