/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.wormbase.gff;
import java.io.*;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.WBGene;
import org.rhwlab.db.beans.GeneRegion;
import org.rhwlab.mysql.Transcript;

/**
 *
 * @author gevirl
 */
public class Gene {
    // updaye the Gene records from Wormbase gff filtered by "Coding_transcript       gene"
    static public void main(String[] args){
        try {
            MySql db = MySql.getMySql();
            BufferedReader reader = new BufferedReader(new FileReader(args[0]));
            String line = reader.readLine();
            while (line != null){
                String[] tokens = line.split("\t");
                int index = tokens[8].indexOf(':')+1;
                String geneId = tokens[8].substring(index);
                
                // find the existing gene record
                org.rhwlab.db.beans.Gene dbGene = new org.rhwlab.db.beans.Gene();
                dbGene.fromMySqlBySequence(db, geneId);
                if (dbGene.getWBGene()==null){
                    // gene not found
                    // figure out the WBGeneID from the transcript id
                    Transcript transcript = new Transcript(geneId);
                    String wbGeneId = transcript.getWBGene();
                    WBGene wbGene = new WBGene();
                    wbGene.fetchFromWormBase(wbGeneId);
                    
                    dbGene = new org.rhwlab.db.beans.Gene(wbGene); 
                    dbGene.updateDB(db);
                    
                    System.out.printf("%s %s\n",geneId,wbGeneId);
                } 
                 // gene is found - is the region there
                 if (dbGene.getRegion()==null){
                    System.out.printf("%s\n",geneId);
                    String chrom = tokens[0].substring(tokens[0].indexOf('_')+1);
                    if (chrom.equals("MtDNA")) chrom = "Mt";
                    int strand = -1;
                    if (tokens[6].equals("+")){
                        strand = 1;
                    }
                    int start = Integer.valueOf(tokens[3]);
                    int end = Integer.valueOf(tokens[4]);
                    dbGene.setRegion(new GeneRegion(chrom,start,end,strand));
                     dbGene.updateDB(db);
                }
                
                line = reader.readLine();
            }
        }catch (Exception exc){
            exc.printStackTrace();
        }
    }
    
}
