/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views.onsetmodel;
import javax.swing.*;

import org.rhwlab.expression.ExpressionTimeSeries;
import org.rhwlab.expression.image.ValueRange;
import java.awt.Graphics2D;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import org.rhwlab.expression.ExpressionWindow;
import org.rhwlab.expression.OnsetExpTimeSeries;
import org.rhwlab.expression.image.LabeledTimeSeriesImage;
import org.rhwlab.expression.image.OnsetTimeSeriesImage;

/**
 *
 * @author gevirl
 */
public class TimeSeriesPanel extends JPanel {
    public TimeSeriesPanel(ExpressionTimeSeries express,Object[] annotations){
        if (annotations!=null && annotations.length>0){
            image = new LabeledTimeSeriesImage();
            image.setTimeseries(express);
            for (Object annotation : annotations){
                image.setAnnotation(annotation.toString(), annotation);
            }
        }
        else if (express instanceof OnsetExpTimeSeries ){
            image = new OnsetTimeSeriesImage();
            image.setTimeseries(express);
            image.setOnsetLabels(true);
        } else {
            
            image = new LabeledTimeSeriesImage();
            image.setTimeseries(express);
        }
        
    }
    public void setScale(ValueRange range){
        image.setYScale(range);
        this.invalidate();
        this.repaint();
    }
    public void setDimension(Dimension dim){
        image.setDimension(dim);
        this.setPreferredSize(new Dimension(dim.width,dim.height+30));
    }
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D) g;
        
        g2.drawImage(image.getImage(),new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,0);        

    } 
    LabeledTimeSeriesImage image;
}
