/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views.onsetmodel;

import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeListener;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.expression.ExpressionOnset;

/**
 *
 * @author gevirl
 */
public class EmbryoSplitPane extends JSplitPane {
    public EmbryoSplitPane(SeriesEmbryo emb,HashMap onsetMap,Dimension onsetsDim,Dimension treeDim)throws Exception {
        this.setOneTouchExpandable(true);
        this.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
        onsetsPanel = new OnsetsScroll(emb,onsetMap,onsetsDim);
        onsetsTreePanel = new OnsetsTreeScroll(emb,treeDim);
        onsetsTreePanel.setPreferredSize(treeDim);
        this.setLeftComponent(onsetsPanel);
        this.setRightComponent(onsetsTreePanel);
        onsetsTreePanel.addListener(onsetsPanel);
    }
    public OnsetsScroll getOnsetsPanel(){
        return this.onsetsPanel;
    }
    public OnsetsTreeScroll getTreePanel(){
        return this.onsetsTreePanel;
    }
    public void moveTo(String leaf){
        onsetsPanel.moveTo(leaf);
        onsetsTreePanel.moveTo(leaf);
    }

    public String getTopCell(){
        return onsetsTreePanel.getTopCell();
    }
    OnsetsScroll onsetsPanel;
    OnsetsTreeScroll onsetsTreePanel;
}
