/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views.onsetmodel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.expression.ExpressionOnset;
import org.rhwlab.imaging.binarytree.TreeMark;

/**
 *
 * @author gevirl
 */
public class EmbryoPanel extends JPanel implements ChangeListener {
    public EmbryoPanel(SeriesEmbryo emb,HashMap onsetMap,Dimension onsetsDim,Dimension treeDim)throws Exception {
        this.setLayout(new BorderLayout());
        
        embryoSplitPanel = new EmbryoSplitPane( emb,onsetMap,onsetsDim,treeDim);
        embryoSplitPanel.setDividerLocation(0.0);
        ScalePanel scalePanel = new ScalePanel(emb,embryoSplitPanel.getOnsetsPanel());
        this.add(scalePanel,BorderLayout.NORTH);
        this.add(embryoSplitPanel,BorderLayout.CENTER);
        
   
        // add marks to the tree image for each onset
        for (Object obj : onsetMap.values()){
            if (obj instanceof ExpressionOnset){
                ExpressionOnset onset = (ExpressionOnset)obj;
                EmbryoCell cell = emb.getCell(onset.getCell());
                int n = onset.getOnset() - cell.getStartTime() + 1;
                OnsetsTreeScroll treePanel = embryoSplitPanel.getTreePanel();
                treePanel.addMark(new TreeMark(cell.getName(),n));
            }
        }        
    }
    public void moveTo(String leaf){
        embryoSplitPanel.moveTo(leaf);
    }
    public void stateChanged(ChangeEvent event){
        embryoSplitPanel.moveTo((String)event.getSource());
    }
    public OnsetsScroll getOnsetsPanel(){
        return this.embryoSplitPanel.getOnsetsPanel();
    }
    public OnsetsTreeScroll getOnsetsTreePanel() {
        return this.embryoSplitPanel.getTreePanel();
    }
    public String getTopCell(){
        return embryoSplitPanel.getTopCell();
    }
    
    public EmbryoSplitPane getSplitPane(){
        return this.embryoSplitPanel;
    }

    EmbryoSplitPane embryoSplitPanel;
}
