/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views;
import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
/**
 *
 * @author gevirl
 */
public class PropertiesDialog extends JDialog {
    public PropertiesDialog(Frame owner,Properties ps,boolean mode){
        super(owner,mode);
        this.props = ps;
        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        
        JPanel propsPanel = new JPanel();
        propsPanel.setLayout(new BoxLayout(propsPanel,BoxLayout.Y_AXIS));     
        for (Object key : props.keySet()){
            String name = (String)key;
            JPanel propPanel = new JPanel();
            propPanel.setLayout(new BoxLayout(propPanel,BoxLayout.X_AXIS));
            JCheckBox box = new JCheckBox(name,true);
            boxes.add(box);
            propPanel.add(box);
            JTextField field = new JTextField(props.getProperty(name));
            fields.add(field);
            propPanel.add(field);
            propsPanel.add(propPanel);
        }
        mainPanel.add(propsPanel,BorderLayout.CENTER);
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                okStatus = true;
                PropertiesDialog.this.setVisible(false);
                for (int i=0 ; i<boxes.size();++i){
                    JCheckBox box = boxes.get(i);
                    if (box.isSelected()){
                        props.setProperty(box.getText(),fields.get(i).getText());
                    } else {
                        props.remove(box.getText());
                    }
                }
            }
        });
        buttonPanel.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                okStatus = false;
                PropertiesDialog.this.setVisible(false);
            }
        });        
        buttonPanel.add(cancel);
        mainPanel.add(buttonPanel,BorderLayout.SOUTH);
        
        this.setContentPane(mainPanel);
    }
    public boolean isOk(){
        return okStatus;
    }
    public Properties getProperties(){
        return props;
    }
    ArrayList<JCheckBox> boxes = new ArrayList<JCheckBox>();
    ArrayList<JTextField> fields = new ArrayList<JTextField>();
    boolean okStatus= false;
    protected Properties props;
}
