/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.expression.ExpressionTimeSeries;
import org.rhwlab.kdeexpression.KDEExpressionFile;

/**
 *
 * @author gevirl
 */
// display the KDE expression for a given leaf cell 
public class KDECellExpressionPanel extends JPanel{
    public KDECellExpressionPanel(KDEExpressionFile kdeFile,EmbryoCell leaf,SeriesEmbryo zblotEmbryo,SeriesEmbryo rawEmbryo)throws Exception {
        XYSeriesCollection collection = new XYSeriesCollection();
        ArrayList<Double> expList = new ArrayList<Double>();
        kdeFile.buildTimeSeries(expList, leaf);
        double[] exp  = new double[expList.size()];
        for (int i=0 ; i<exp.length ; ++i){
            exp[i] = expList.get(i);
        }
        double[] avgExp = average(exp,3);
        XYSeries series = new XYSeries("New");
        for (int i=0 ; i<avgExp.length;++i){
            series.add(i, avgExp[i]);
        } 
        collection.addSeries(series);     
//        kdeFile.buildCollection(collection, leaf);
        
        // add the raw expresion to the collectiom 
        ExpressionTimeSeries rawTimeSeries  = ExpressionTimeSeries.factory(rawEmbryo.getCell(leaf.getName()));
        double[] avgRaw = average(toDouble(rawTimeSeries.getInteger(0, rawTimeSeries.size())),3);
        XYSeriesCollection rawCollection = new XYSeriesCollection();
        XYSeries rawSeries = new XYSeries("Raw");
        for (int i=0 ; i<avgRaw.length;++i){
            rawSeries.add(i, avgRaw[i]);
        } 
        rawCollection.addSeries(rawSeries);
        NumberAxis rawAxis = new NumberAxis("Raw");
        rawAxis.setRange(rawEmbryo.minExpression(),rawEmbryo.maxExpression());
        
        // add the zblot expresion to the collectiom 
        ExpressionTimeSeries zblotTimeSeries  = ExpressionTimeSeries.factory(zblotEmbryo.getCell(leaf.getName()));
        double[] avgZblot = average(toDouble(zblotTimeSeries.getInteger(0, zblotTimeSeries.size())),3);
        XYSeriesCollection zblotCollection = new XYSeriesCollection();
        XYSeries zblotSeries = new XYSeries("zblot");
        for (int i=0 ; i<avgZblot.length;++i){
            zblotSeries.add(i, avgZblot[i]);
        } 
        zblotCollection.addSeries(zblotSeries);
        NumberAxis zblotAxis = new NumberAxis("zblot");
        zblotAxis.setRange(zblotEmbryo.minExpression(),zblotEmbryo.maxExpression());        

        String title = leaf.getName();
        JFreeChart chart = ChartFactory.createXYLineChart(title,"Time","Expression",collection,
                PlotOrientation.VERTICAL,true,true,false);
        XYPlot plot = (XYPlot) chart.getPlot();

        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setRange(kdeFile.getMin(),kdeFile.getmax()); 
        plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
        
        plot.setDataset(1, rawCollection);
        plot.setRangeAxis(1, rawAxis);
        plot.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        plot.mapDatasetToRangeAxis(1, 1); 
        
        plot.setDataset(2, zblotCollection);
        plot.setRangeAxis(2, zblotAxis);
        plot.setRangeAxisLocation(2, AxisLocation.TOP_OR_LEFT);
        plot.mapDatasetToRangeAxis(2, 2);         
        
        plot.mapDatasetToRangeAxis(0, 0);
        
        XYLineAndShapeRenderer rend = new  XYLineAndShapeRenderer();
        rend.setBaseShapesVisible(false);
        rend.setSeriesPaint(0, Color.BLUE);
        plot.setRenderer(0, rend);        
        
        XYLineAndShapeRenderer rawRend = new  XYLineAndShapeRenderer();
        rawRend.setBaseShapesVisible(false);
        rawRend.setSeriesPaint(0, Color.BLACK);
        plot.setRenderer(1, rawRend);
        
        XYLineAndShapeRenderer zblotRend = new  XYLineAndShapeRenderer();
        zblotRend.setBaseShapesVisible(false);
        zblotRend.setSeriesPaint(0, Color.RED);
        plot.setRenderer(2, zblotRend);        

        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new java.awt.Dimension(800, 400));
        this.add(chartPanel);          
    }
    static private double[] average(double[] values,int n){
        double[] ret = new double[values.length];
        for (int i=0 ; i<values.length ; ++i){
            int count = 0;
            double sum = 0;
            for (int j=-n ; j<=n ; ++j){
                int index = i+j;
                if (index >=0 && index <values.length){
                    ++count;
                    sum = sum + values[index];
                }
            }
            ret[i] = (double)sum/(double)count;
        }
        
        return ret;
    }
    static private double[] toDouble(int[] values){
        double[] ret = new double[values.length];
        for (int i=0 ; i<ret.length ; ++i){
            ret[i] = values[i];
        }
        return ret;
    }
}