/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.mysql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class Transcript {
    public Transcript(){
        
    }
    public Transcript(String name)throws Exception {
        String sql = String.format("Select * from Transcript where TranscriptName = \'%s\'",name);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            setFromResultSet(rs);
        }
    }

    private void setFromResultSet(ResultSet rs)throws Exception {
        this.id = rs.getString("TranscriptName");
        this.wormbase = rs.getString("WBGene");
        this.sequence = rs.getString("Sequence");
        this.CGC = rs.getString("CGC");
        this.chrom = rs.getString("Chrom");
        this.start = rs.getInt("Start");
        this.end = rs.getInt("End");
        
    }
    public void addToDB(PreparedStatement state)throws Exception {
        state.setString(1,id);
        state.setString(2,wormbase);
        state.setString(3,chrom);
        state.setInt(4,start);
        state.setInt(5,end);
        state.setString(6,Character.toString(strand)); 
        state.setString(7,status);
        state.setString(8,transcribed);
        state.execute();
    }
        
    // update the Transcript table with any transcripts in the WormBaseTable
    static public void updateTranscriptTable()throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement(
                "insert into Transcript (CGC,TranscriptName,Length,WBGene,Sequence,Start,End,Chrom) values (?,?,?,?,?,?,?,?)");
/*        
        PreparedStatement selectCoding = MySql.getMySql().getStatement("Select * from WormBaseTranscript where Type = ?");
        selectCoding.setString(1,"mRNA");
        selectCoding.execute();
        ResultSet rs = selectCoding.getResultSet();
*/        
        String sql = "Select * from WormBaseTranscript";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String wbTranscript = rs.getString("Transcript");
            Transcript trans = new Transcript(wbTranscript);
            if (trans.id == null) {
                trans.id = wbTranscript;
                trans.wormbase = rs.getString("WBGene");
                trans.sequence = rs.getString("Sequence");
                String gene = rs.getString("Gene");
                if (!gene.equals(trans.sequence))
                    trans.CGC = gene;
                trans.chrom = rs.getString("Chromosome");
                trans.start = rs.getInt("Start");
                trans.end = rs.getInt("End");   
                
                state.setString(1,trans.CGC);
                state.setString(2,trans.id);
                state.setInt(3,trans.end-trans.start+1);
                state.setString(4,trans.wormbase);
                state.setString(5,trans.sequence);
                state.setInt(6,trans.start); 
                state.setInt(7,trans.end);
                state.setString(8,trans.chrom);
                state.execute();   
                
                int iusadf=0;
            }
            
        }
    }
    // loads the WormBaseTranscript table from a gff downloaded from wormbase
    static public void loadFromWormBaseGFF(File file) throws Exception {
        PreparedStatement wbgeneState = MySql.getMySql().getStatement("select * from WormBaseGene where WBGene= ?");
        PreparedStatement seqState = MySql.getMySql().getStatement("select * from WormBaseGene where Sequence= ?");
        PreparedStatement state = 
                MySql.getMySql().getStatement
                ("insert into WormBaseTranscript (Transcript,WBGene,Sequence,Gene,Chromosome,Start,End,Strand,Type) values (?,?,?,?,?,?,?,?,?)");
        
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
 //           String chrom = tokens[0].substring(11);
            String chrom = tokens[0];
            state.setString(5, chrom);
            int start = Integer.valueOf(tokens[3]);
            state.setInt(6, start);
            int end = Integer.valueOf(tokens[4]);
            state.setInt(7, end);
            String strand = tokens[6];
            state.setString(8, strand);
            String type = tokens[2];
            state.setString(9,type);
            
            String[] data = tokens[8].split(";");
            HashMap<String,String> dataMap = new HashMap<String,String>();
            for (String dataItem : data){
                String[] dataTokens  = dataItem.split("=");
                dataMap.put(dataTokens[0], dataTokens[1]);
                
            }
            String id = dataMap.get("ID");
            int index = id.indexOf(':')+1;
            String transcript = id.substring(index);
            state.setString(1, transcript);
            
            String parent;
            String parentStr = dataMap.get("Parent");
            if (parentStr == null){
                char lst = transcript.charAt(transcript.length()-1);
                if (!Character.isDigit(lst)){
                    parent = transcript.substring(0,transcript.length()-1);
                    int oiuahsdf=0;
                }else{
                    parent = transcript;
                }
            } else {
                index = parentStr.indexOf(':')+1;
                 parent = parentStr.substring(index);
            }
            
            if (parent.startsWith("WBGene")){
                wbgeneState.setString(1, parent);
                wbgeneState.execute();
                ResultSet rs = wbgeneState.getResultSet();
                if (rs.next()){
                    state.setString(2, parent);
                    String gene = rs.getString("CGC");
                    String seq = rs.getString("Sequence");
                    if (gene.equals("")){
                        gene = seq;
                    }
                    state.setString(3, seq);
                    state.setString(4, gene);
                    state.execute();
                    
                } else {
                    System.err.printf("WBGene not found: %s for Transcript: %s\n", parent,transcript);
                }
            }else {
                seqState.setString(1, parent);
                seqState.execute();
                ResultSet rs = seqState.getResultSet();
                if (rs.next()){
                    String wbgene = rs.getString("WBGene");
                    state.setString(3, parent);
                    String gene = rs.getString("CGC");
                    if (gene.equals("")){
                        gene = parent;
                    }                    
                    state.setString(4,gene);
                    state.setString(2, wbgene);
                    state.execute();
                } else {
                    System.err.printf("Sequence not found: %s for Transcript: %s\n", parent,transcript);
                }
            }
            
            line = reader.readLine();
        }
    }
    static public void loadFromGFF(File gff)throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Insert into IntegratedTranscript (ID,Wormbase,Chrom,Start,End,Strand,Status,Transcribed) values (?,?,?,?,?,?,?,?)");
        GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(gff));
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
        String line = reader.readLine();
        int count=0;
        while (line != null){
            line = line.trim();
            if (line.length()>0 && line.charAt(0) != '#'){
                String[] tokens = line.split("\t");
                if (tokens[2].equals("transcript")){
                    
                    HashMap<String,String> map = new HashMap<String,String>();
                    String[] descriptions = tokens[8].split(";");
                    for (String desc : descriptions){
                        String[] descPair = desc.split("=");
                        map.put(descPair[0],descPair[1]);
                    }

                    Transcript trans = new Transcript();
                    trans.chrom = tokens[0];
                    trans.start = Integer.valueOf(tokens[3]);
                    trans.end = Integer.valueOf(tokens[4]);
                    trans.strand = tokens[6].charAt(0); 
                    trans.id = map.get("ID");
                    trans.wormbase = map.get("overlapping_wormbase_transcript");
                    trans.status = map.get("prediction_status");
                    trans.transcribed = map.get("transcribed");

                    // add it to the db
                    trans.addToDB(state);
                    ++count;
                }
            }
            line = reader.readLine();
        }
        System.out.println(count);
    }
    public String  getName(){
        return id;
    }
    public String getSequence(){
        return this.sequence;
    }
    public String getGene(){
        if (CGC == null || CGC.equals("")) {
            return sequence;
        }
        return CGC;
    }
    public String getWBGene(){
        return this.wormbase;
    }
    
    static public void main(String[] args)throws Exception {
//        loadFromWormBaseGFF(new File(args[0]));
        updateTranscriptTable();
    }
    String id;        // transcript name
    String wormbase;  // WBGene  id 
    int start;
    int end;
    String chrom;
    char strand;
    String status;
    String transcribed;
    String CGC;        // CGC name if exists otherwise the sequence name
    String sequence;    // sequence name
}
