/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.mysql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class Exon {
    public void addToExonDB(PreparedStatement state)throws Exception {
        state.setString(1,id);
        state.setString(2,chrom);
        state.setInt(3,start);
        state.setInt(4,end);
        state.setString(5,Character.toString(strand)); 
        state.setString(6,status);
        state.execute();
    } 
    public void addToModelDB(PreparedStatement state)throws Exception {
        for (String parent : parentList){
            state.setString(1, id);
            state.setString(2, parent);
            state.execute();
        }
    }
    static public void loadFromGFF(File gff)throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Insert into IntegratedExon (ID,Chrom,Start,End,Strand,Status) values (?,?,?,?,?,?)");
        PreparedStatement modelstate = MySql.getMySql().getStatement("Insert into TranscriptModel (ExonID,TranscriptID) values (?,?)");
        GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(gff));
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
        String line = reader.readLine();
        int count=0;
        while (line != null){
            line = line.trim();
            if (line.length()>0 && line.charAt(0) != '#'){
                String[] tokens = line.split("\t");
                if (tokens[2].equals("exon")){
                    
                    HashMap<String,String> map = new HashMap<String,String>();
                    String[] descriptions = tokens[8].split(";");
                    for (String desc : descriptions){
                        String[] descPair = desc.split("=");
                        map.put(descPair[0],descPair[1]);
                    }

                    Exon exon = new Exon();
                    exon.chrom = tokens[0];
                    exon.start = Integer.valueOf(tokens[3]);
                    exon.end = Integer.valueOf(tokens[4]);
                    exon.strand = tokens[6].charAt(0); 
                    exon.id = map.get("ID");
                    exon.status = map.get("prediction_status");
                    String parentString = map.get("Parent");
                    if (parentString != null) {
                        String[] parents = parentString.split(",");
                        exon.parentList.addAll(Arrays.asList(parents));
                    }

                    // add it to the db
                    exon.addToExonDB(state);
                    exon.addToModelDB(modelstate);
                    
                    ++count;
                }
            }
            line = reader.readLine();
            System.out.println(count);
        }
        
    }  
    static public void main(String[] args)throws Exception {
        loadFromGFF(new File(args[0]));
    }    
    String id;
    int start;
    int end;
    String chrom;
    char strand;
    String status;
    ArrayList<String> parentList = new ArrayList<String>();
}
