
package org.rhwlab.imaging.binarytree;
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
/**
 *
 * @author gevirl
 */

public class VerticalTreePanel extends JPanel {
    public VerticalTreePanel(BinaryTreeNode root,int height,float timeScale,int labelWidth) throws Exception {
        image = new VerticalTreeImage(root.getLabel(),root,height,timeScale,labelWidth,Utils.getMaxDepth(root));
        
        this.setPreferredSize(image.getSize());
    }
    public void setColorScale(ColorScale scale){
        image.setColorScale(scale);
    }
    public void setLineWidth(int w){
        image.setLineWidth(w);
    }
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D) g;
        
        // clear the panel
        Color save = g2.getColor();
        g2.setColor(Color.white);
        Dimension d = this.getSize();
        g2.fillRect(0,0,d.width,d.height);
        g2.setColor(save);
        
        g2.drawImage(image.getImage(),
                new AffineTransformOp(new AffineTransform(),AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,0);
    }     
    public VerticalTreeImage getImage(){
        return image;
    }
    VerticalTreeImage image;
}
