/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;

/**
 *
 * @author gevirl
 */
public class VerticalMultiSeriesLineageTreeImage {
    public VerticalMultiSeriesLineageTreeImage(SeriesEmbryo[] embryos,ColorScale[] scales,String lineageRoot,int height,float timeScale,int labelWidth)throws Exception {
        seriesImages = new VerticalTreeImage[embryos.length];
        
        int w = 0;
        for (int i=0 ; i<embryos.length ; ++i){
            EmbryoCell cell =embryos[i].getCell(lineageRoot);
            
            seriesImages[i] = new VerticalTreeImage(embryos[i].getTitle(),cell,height,timeScale,labelWidth,embryos[i].maxSulstonTime());
            seriesImages[i].setColorScale(scales[i]);
            w = w + seriesImages[i].getSize().width;
        }
        this.fullDim = new Dimension(w,height);
    }
    public BufferedImage getImage(){
        BufferedImage bigimage = new BufferedImage(fullDim.width,fullDim.height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = bigimage.createGraphics(); 
        
        int pos = 0;
        for (int i=0 ; i<seriesImages.length ; ++i){
            BufferedImage image = seriesImages[i].getImage();
            g2.drawImage(image,new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),pos,0);   
            pos = pos + image.getWidth();
        }
        return bigimage;  
    }
    public Dimension getSize(){
        return fullDim;
    }
    Dimension fullDim;
    VerticalTreeImage[] seriesImages;
}
